/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import wardentools.effect.ModEffects;
import wardentools.misc.WardenLaserAttack;
import wardentools.network.PacketHandler;
import wardentools.network.ParticulesSoundsEffects.WardenLaserParticleAndSoundPacket;

@Mod.EventBusSubscriber(modid="wardentools", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WardenHeartItem
extends Item {
    private final WardenLaserAttack laserAttack = new WardenLaserAttack();
    private static final int laserLength = 14;
    private Player currentPlayer;

    public WardenHeartItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (WardenHeartItem.isCorruptionVessel(player)) {
                player.getCooldowns().addCooldown((Item)this, 120);
                long gameTime = serverLevel.getGameTime();
                Vec3 startPosition = player.position().add(0.0, 1.0, 0.0);
                Vec3 direction = player.getLookAngle();
                this.laserAttack.tick(serverLevel, player, gameTime, startPosition, direction, 14);
                PacketHandler.sendToAllClient(new WardenLaserParticleAndSoundPacket(startPosition, direction, 14));
                return InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
            }
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(interactionHand));
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        this.currentPlayer = event.player;
    }

    private static boolean isCorruptionVessel(Player player) {
        if (player == null) {
            return false;
        }
        return player.getEffect((Holder)ModEffects.CORRUPTION_VESSEL.getHolder().get()) != null;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return WardenHeartItem.isCorruptionVessel(this.currentPlayer);
    }
}

