/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.custom.NoctilureEntity;
import wardentools.sounds.ModSounds;

public class WhistleItem
extends Item {
    private static final int USE_DURATION = 100;
    private static final SoundEvent SOUND = (SoundEvent)ModSounds.WHISTLE.get();
    private static final float callRange = 100.0f;
    private SoundInstance lastSoundInstance;

    public WhistleItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        this.play(level, player);
        player.getCooldowns().addCooldown((Item)this, 100);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!level.isClientSide) {
            this.callForTamedNoctilure(level, player);
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        entity.stopUsingItem();
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.getSoundManager().stop(this.lastSoundInstance);
        super.onStopUsing(stack, entity, count);
    }

    public boolean isUsing() {
        Minecraft minecraft = Minecraft.getInstance();
        return minecraft.getSoundManager().isActive(this.lastSoundInstance);
    }

    private void callForTamedNoctilure(Level level, Player player) {
        AABB aabb = player.getBoundingBox().inflate(100.0);
        level.getEntitiesOfClass(NoctilureEntity.class, aabb).forEach(noctilure -> {
            if (noctilure.isTamed() && noctilure.getOwner() == player) {
                noctilure.call();
            }
        });
    }

    public int getUseDuration(@NotNull ItemStack stack) {
        return 100;
    }

    private void play(Level level, Player player) {
        if (level.isClientSide) {
            this.lastSoundInstance = new EntityBoundSoundInstance(SOUND, SoundSource.PLAYERS, 0.8f, 1.0f, (Entity)player, 1L);
            Minecraft.getInstance().getSoundManager().play(this.lastSoundInstance);
        }
        level.gameEvent((Holder)GameEvent.INSTRUMENT_PLAY, player.position(), GameEvent.Context.of((Entity)player));
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }
}

