/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;
import wardentools.misc.wind.WhisperManager;
import wardentools.worldgen.dimension.ModDimensions;

public class WindWhispererItem
extends BlockItem {
    private Player currentPlayer;
    private final RandomSource rand = RandomSource.create();
    private static final int PROB_WHISPER = 5000;

    public WindWhispererItem(Block block, Item.Properties prop) {
        super(block, prop);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        Player player;
        this.currentPlayer = entity instanceof Player ? (player = (Player)entity) : null;
        super.inventoryTick(stack, level, entity, slot, selected);
        if (entity instanceof LocalPlayer && (player = (LocalPlayer)entity).level().isClientSide() && WindWhispererItem.isInHotbar(player) && WindWhispererItem.isInAbyss(player) && this.rand.nextInt(5000) == 1) {
            WhisperManager.sendRandomWhisperToPlayer((LocalPlayer)player);
        }
    }

    private static boolean isInHotbar(Player player) {
        for (int i = 0; i < 9; ++i) {
            if (!(player.getInventory().getItem(i).getItem() instanceof WindWhispererItem)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInAbyss(Player player) {
        if (player == null) {
            return false;
        }
        return player.level().dimension() == ModDimensions.ABYSS_LEVEL_KEY;
    }

    public boolean isFoil(@NotNull ItemStack itemStack) {
        return this.currentPlayer != null && WindWhispererItem.isInHotbar(this.currentPlayer) && WindWhispererItem.isInAbyss(this.currentPlayer);
    }
}

