/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items.enchantment;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentGenerator {
    public static final ResourceKey<Enchantment> STEALTH_KEY = EnchantmentGenerator.key("stealth");

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        EnchantmentGenerator.register(context, STEALTH_KEY, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (HolderSet)items.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE), (int)5, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)11), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})));
    }

    private static ResourceKey<Enchantment> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)name));
    }

    private static void register(BootstrapContext<Enchantment> registry, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        registry.register(key, (Object)builder.build(key.location()));
    }
}

