/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import wardentools.items.recipe.ModRecipes;
import wardentools.items.recipe.RadianceCatalystRecipeInput;

public record RadianceCatalystRecipe(Ingredient inputItem, ItemStack output, int energyCost) implements Recipe<RadianceCatalystRecipeInput>
{
    public boolean matches(@NotNull RadianceCatalystRecipeInput input, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.inputItem.test(input.getItem(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull RadianceCatalystRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.inputItem);
        return list;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.RADIANCE_RECIPE_SRZ.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.RADIANCE_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RadianceCatalystRecipe> {
        public static final MapCodec<RadianceCatalystRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(RadianceCatalystRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(RadianceCatalystRecipe::output), (App)Codec.INT.fieldOf("energy_cost").forGetter(RadianceCatalystRecipe::energyCost)).apply((Applicative)inst, RadianceCatalystRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RadianceCatalystRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RadianceCatalystRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, RadianceCatalystRecipe::output, (StreamCodec)ByteBufCodecs.VAR_INT, RadianceCatalystRecipe::energyCost, RadianceCatalystRecipe::new);

        @NotNull
        public MapCodec<RadianceCatalystRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, RadianceCatalystRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

