/*
 * Decompiled with CFR 0.152.
 */
package wardentools.misc.wind;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import wardentools.misc.wind.WindWhispers;
import wardentools.network.PacketHandler;
import wardentools.network.ParticulesSoundsEffects.WindWhisperMessageAndSound;
import wardentools.sounds.ModSounds;

@Mod.EventBusSubscriber(modid="wardentools")
public class WhisperManager {
    public static final WhisperManager INSTANCE = new WhisperManager();
    public static final WindWhispers WHISPERS = new WindWhispers();
    private static final int MIN_TIME_BETWEEN_WHISPERS = 500;
    private int nextMinTime = 500;
    private int timeSinceLastWhisper = 0;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        INSTANCE.tick();
    }

    public void tick() {
        ++this.timeSinceLastWhisper;
    }

    public boolean sendRandomWhisperToAllPlayers(ServerLevel level) {
        if (this.timeSinceLastWhisper > this.nextMinTime) {
            this.timeSinceLastWhisper = 0;
            this.nextMinTime = 500 + level.random.nextInt(500);
            level.players().forEach(this::sendRandomWhisperToPlayer);
            return true;
        }
        return false;
    }

    public void sendRandomWhisperToPlayer(@NotNull ServerPlayer player) {
        PacketHandler.sendToClient(new WindWhisperMessageAndSound(), player);
    }

    public static void sendRandomWhisperToPlayer(@NotNull LocalPlayer player) {
        player.playSound((SoundEvent)ModSounds.WIND_WHISPERS.get(), 5.0f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f + 1.0f);
        Holder biomeHolder = player.level().getBiome(player.blockPosition());
        Component whisper = WHISPERS.getContextualWhisper((Holder<Biome>)biomeHolder);
        MutableComponent windName = Component.translatable((String)"message.wardentools.windname");
        WhisperManager.sendMessage((Player)player, windName.getString() + " " + whisper.getString());
    }

    private static void sendMessage(Player player, String message) {
        player.sendSystemMessage((Component)Component.literal((String)message));
    }
}

