/*
 * Decompiled with CFR 0.152.
 */
package wardentools.misc.wind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.biome.Biome;
import wardentools.misc.wind.ContextualWind;
import wardentools.misc.wind.Whisper;
import wardentools.misc.wind.WhisperTags;
import wardentools.network.PacketHandler;
import wardentools.playerdata.whispers.KnownWhispersDataProvider;
import wardentools.playerdata.whispers.WhisperDataSyncServerPacket;

public class WindWhispers {
    private final Map<Integer, Whisper> whispers = new HashMap<Integer, Whisper>();
    public final WhisperTags whisperTags = new WhisperTags();

    public WindWhispers() {
        int globalId = 0;
        for (WhisperTags.Tag tag : WhisperTags.Tag.values()) {
            for (int i = 1; i <= tag.getNumberOfWhispers(); ++i) {
                Whisper whisper = new Whisper(tag, i, globalId);
                this.whispers.put(++globalId, whisper);
                this.whisperTags.addTag(tag, whisper);
            }
        }
        this.whisperTags.initUnContextualWhispers();
    }

    @Nullable
    public Whisper getNewRandomContextualWhisper(WhisperTags.Tag tag) {
        if (Minecraft.getInstance().player == null) {
            return null;
        }
        ArrayList availableWhispers = new ArrayList();
        Minecraft.getInstance().player.getCapability(KnownWhispersDataProvider.WHISPERS_CAPABILITY).ifPresent(data -> {
            for (Whisper whisper : this.whisperTags.getContextualWhispers(tag)) {
                if (data.knowsWhisper(whisper.globalId())) continue;
                availableWhispers.add(whisper);
            }
        });
        if (availableWhispers.isEmpty()) {
            return null;
        }
        Random rand = new Random();
        Whisper whisper = (Whisper)availableWhispers.get(rand.nextInt(availableWhispers.size()));
        WindWhispers.addWhisperIdToPlayer(whisper);
        return whisper;
    }

    public Whisper getRandomWhisper() {
        List<Whisper> whisperList = this.whispers.values().stream().toList();
        Random rand = new Random();
        Whisper whisper = whisperList.get(rand.nextInt(whisperList.size()));
        WindWhispers.addWhisperIdToPlayer(whisper);
        return whisper;
    }

    public static void addWhisperIdToPlayer(Whisper whisper) {
        if (Minecraft.getInstance().player != null) {
            Minecraft.getInstance().player.getCapability(KnownWhispersDataProvider.WHISPERS_CAPABILITY).ifPresent(data -> {
                if (!data.knowsWhisper(whisper.globalId())) {
                    data.addKnownWhisper(whisper.globalId());
                }
            });
            PacketHandler.sendToServer(new WhisperDataSyncServerPacket(whisper.globalId()));
        }
    }

    public Component getContextualWhisper(Holder<Biome> biomeHolder) {
        Whisper whisper = this.getNewRandomContextualWhisper(ContextualWind.getTagForBiome(biomeHolder));
        return whisper == null ? this.getRandomWhisper().whisper() : whisper.whisper();
    }

    public static String getLockedString() {
        return Component.translatable((String)"message.wardentools.locked").getString();
    }
}

