/*
 * Decompiled with CFR 0.152.
 */
package wardentools.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wardentools.entity.custom.NoctilureEntity;

@Mixin(value={Gui.class})
public class GuiRenderingMixin {
    @Unique
    private static final ResourceLocation SPRINT_BAR_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/sprint_bar/noctilure_background.png");
    @Unique
    private static final ResourceLocation SPRINT_BAR_PROGRESS = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/sprint_bar/noctilure_progress.png");

    @Inject(method={"renderHotbarAndDecorations"}, at={@At(value="TAIL")})
    private void onGuiRendering(GuiGraphics graphics, DeltaTracker tracker, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && minecraft.player.getVehicle() != null) {
            int screenWidth = minecraft.getWindow().getGuiScaledWidth();
            int screenHeight = minecraft.getWindow().getGuiScaledHeight();
            RenderSystem.enableBlend();
            Entity entity = minecraft.player.getVehicle();
            if (entity instanceof NoctilureEntity) {
                NoctilureEntity noctilure = (NoctilureEntity)entity;
                minecraft.getProfiler().push("energy");
                float energyNorm = (float)noctilure.getSprintEnergy() / 2000.0f;
                int progress = (int)((1.0f - energyNorm) * 182.0f);
                int barWidth = 182;
                int barHeight = 5;
                int y = screenHeight - 29;
                int x = screenWidth / 2 - barWidth / 2;
                graphics.blit(SPRINT_BAR_BACKGROUND, x, y, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
                graphics.blit(SPRINT_BAR_PROGRESS, x, y, 0.0f, 0.0f, barWidth - progress, barHeight, barWidth, barHeight);
                minecraft.getProfiler().pop();
            }
        }
    }
}

