/*
 * Decompiled with CFR 0.152.
 */
package wardentools.mixin;

import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.level.material.FogType;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wardentools.client.rendering.LevelRendererUtils;
import wardentools.weather.AbyssFogClientHandler;
import wardentools.weather.AbyssWeatherEvent;
import wardentools.worldgen.dimension.ModDimensions;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Shadow
    private ClientLevel level;

    @Inject(method={"renderSky"}, at={@At(value="HEAD")})
    private void onRenderSky(Matrix4f pose, Matrix4f matrix, float time, Camera cam, boolean bool, Runnable runnable, CallbackInfo ci) {
        if (cam.getEntity().level().dimension() != ModDimensions.ABYSS_LEVEL_KEY) {
            return;
        }
        int BRIGHTNESS = (int)(230.0f * AbyssWeatherEvent.CLIENT_WEATHER.currentFogDistance() / AbyssFogClientHandler.getMaxFogDistance());
        LevelRenderer levelRenderer = (LevelRenderer)this;
        if (this.level == null) {
            return;
        }
        if (this.level.effects().renderSky(this.level, levelRenderer.getTicks(), time, cam, pose, bool, runnable)) {
            return;
        }
        runnable.run();
        FogType fogtype = cam.getFluidInCamera();
        if (fogtype != FogType.POWDER_SNOW && fogtype != FogType.LAVA && this.level.dimension() == ModDimensions.ABYSS_LEVEL_KEY) {
            LevelRendererUtils.renderSky(this.level, pose, BRIGHTNESS);
        }
    }
}

