/*
 * Decompiled with CFR 0.152.
 */
package wardentools.mixin;

import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wardentools.worldgen.dimension.ModDimensions;

@Mixin(value={Minecraft.class})
public class MinecraftMusicMixin {
    @Shadow
    public Screen screen;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Final
    @Shadow
    public Gui gui;
    @Final
    @Shadow
    private MusicManager musicManager;

    @Inject(method={"getSituationalMusic"}, at={@At(value="HEAD")}, cancellable=true)
    public void overrideGetSituationalMusic(CallbackInfoReturnable<Music> cir) {
        Music music = (Music)Optionull.map((Object)this.screen, Screen::getBackgroundMusic);
        if (music != null) {
            cir.setReturnValue((Object)music);
            cir.cancel();
        } else if (this.player != null) {
            Holder holder = this.player.level().getBiome(this.player.blockPosition());
            if (this.player.level().dimension() == Level.END) {
                cir.setReturnValue((Object)(this.gui.getBossOverlay().shouldPlayMusic() ? Musics.END_BOSS : Musics.END));
            } else if (this.player.level().dimension() == ModDimensions.ABYSS_LEVEL_KEY) {
                cir.setReturnValue((Object)((Biome)holder.value()).getBackgroundMusic().orElse(Musics.GAME));
            } else if (!(this.musicManager.isPlayingMusic(Musics.UNDER_WATER) || this.player.isUnderWater() && holder.is(BiomeTags.PLAYS_UNDERWATER_MUSIC))) {
                cir.setReturnValue((Object)(this.player.level().dimension() != Level.NETHER && this.player.getAbilities().instabuild && this.player.getAbilities().mayfly ? Musics.CREATIVE : ((Biome)holder.value()).getBackgroundMusic().orElse(Musics.GAME)));
            } else {
                cir.setReturnValue((Object)Musics.UNDER_WATER);
            }
            cir.cancel();
        }
    }
}

