/*
 * Decompiled with CFR 0.152.
 */
package wardentools.network.ParticulesSoundsEffects;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.slf4j.Logger;
import wardentools.particle.ParticleRegistry;

public class LivingSproutBurstPacket {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BlockPos pos;

    public LivingSproutBurstPacket(BlockPos pos) {
        this.pos = pos;
    }

    public LivingSproutBurstPacket(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> LivingSproutBurstPacket.handlePacket(this));
        context.setPacketHandled(true);
    }

    private static void handlePacket(LivingSproutBurstPacket msg) {
        BlockPos pos = msg.pos;
        try (ClientLevel level = Minecraft.getInstance().level;){
            if (level != null) {
                int i;
                for (i = 0; i < 10; ++i) {
                    double offsetX = (level.random.nextFloat() - 0.5f) * 0.2f;
                    double offsetY = level.random.nextFloat() * 0.2f;
                    double offsetZ = (level.random.nextFloat() - 0.5f) * 0.2f;
                    level.addParticle((ParticleOptions)ParticleTypes.WHITE_ASH, (double)((float)pos.getX() + 0.5f) + offsetX, (double)((float)pos.getY() + 0.5f) + offsetY, (double)((float)pos.getZ() + 0.5f) + offsetZ, 0.0, (double)0.05f, 0.0);
                }
                for (i = 0; i < 40; ++i) {
                    double theta = Math.PI * 2 * (double)level.random.nextFloat();
                    double phi = Math.acos(2.0f * level.random.nextFloat() - 1.0f);
                    double r = 0.3f;
                    double offsetX = r * Math.sin(phi) * Math.cos(theta);
                    double offsetY = r * Math.cos(phi);
                    double offsetZ = r * Math.sin(phi) * Math.sin(theta);
                    level.addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), offsetX, offsetY, offsetZ);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error handling LivingSproutBurstPacket: {}", (Object)e.getMessage());
        }
    }
}

