/*
 * Decompiled with CFR 0.152.
 */
package wardentools.network.ParticulesSoundsEffects;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.event.network.CustomPayloadEvent;
import wardentools.blockentity.RadianceCatalystBlockEntity;

public class ParticleRadianceCatalystCharging {
    private final BlockPos pos;
    private static final double speedReduction = 15.0;

    public ParticleRadianceCatalystCharging(BlockPos pos) {
        this.pos = pos;
    }

    public ParticleRadianceCatalystCharging(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> ParticleRadianceCatalystCharging.handlePacket(this));
        context.setPacketHandled(true);
    }

    private static void handlePacket(ParticleRadianceCatalystCharging msg) {
        BlockPos pos = msg.pos;
        try (ClientLevel level = Minecraft.getInstance().level;){
            if (level != null) {
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + 0.5;
                double z = (double)pos.getZ() + 0.5;
                double offsetX = (level.random.nextDouble() - 0.5) * 2.0;
                double offsetY = (level.random.nextDouble() - 0.5) * 2.0;
                double offsetZ = (level.random.nextDouble() - 0.5) * 2.0;
                level.addParticle(RadianceCatalystBlockEntity.PARTICLE, true, x + offsetX, y + offsetY, z + offsetZ, -offsetX / 15.0, -offsetY / 15.0, -offsetZ / 15.0);
                if (level.random.nextInt(20) == 1) {
                    level.playLocalSound(x, y, z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

