/*
 * Decompiled with CFR 0.152.
 */
package wardentools.network.ParticulesSoundsEffects;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.network.CustomPayloadEvent;
import wardentools.particle.ParticleRegistry;

public class ParticleRadianceImplosion {
    private static final double SPEED = 0.2;
    private static final double RADIUS = 5.0;
    private final Vec3 source;

    public ParticleRadianceImplosion(Vec3 source) {
        this.source = source;
    }

    public ParticleRadianceImplosion(FriendlyByteBuf buffer) {
        this.source = buffer.readVec3();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeVec3(this.source);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> ParticleRadianceImplosion.handlePacket(this));
        context.setPacketHandled(true);
    }

    private static void handlePacket(ParticleRadianceImplosion msg) {
        Vec3 source = msg.source;
        try (ClientLevel level = Minecraft.getInstance().level;){
            if (level != null) {
                for (int i = 0; i < 100; ++i) {
                    double offsetX = (level.random.nextDouble() - 0.5) * 5.0;
                    double offsetY = (level.random.nextDouble() - 0.5) * 5.0;
                    double offsetZ = (level.random.nextDouble() - 0.5) * 5.0;
                    double norm = Math.sqrt(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ);
                    double speed = 0.2 / norm;
                    level.addParticle((ParticleOptions)ParticleRegistry.RADIANCE.get(), source.x + offsetX, source.y + offsetY, source.z + offsetZ, -offsetX * speed, -offsetY * speed, -offsetZ * speed);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

