/*
 * Decompiled with CFR 0.152.
 */
package wardentools.network.ParticulesSoundsEffects;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import wardentools.particle.ParticleRegistry;

public class ParticleWardenDeathPacket {
    private final BlockPos pos;

    public ParticleWardenDeathPacket(BlockPos pos) {
        this.pos = pos;
    }

    public ParticleWardenDeathPacket(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> ParticleWardenDeathPacket.handlePacket(this));
        context.setPacketHandled(true);
    }

    private static void handlePacket(ParticleWardenDeathPacket msg) {
        BlockPos pos = msg.pos;
        try (ClientLevel level = Minecraft.getInstance().level;){
            if (level != null) {
                double offsetX;
                int i;
                double x = pos.getX();
                double y = pos.getY();
                double z = pos.getZ();
                for (i = 0; i < 100; ++i) {
                    offsetX = (level.random.nextDouble() - 0.5) * 0.6;
                    double offsetY = (level.random.nextDouble() - 0.5) * 0.6;
                    double offsetZ = (level.random.nextDouble() - 0.5) * 0.6;
                    level.addParticle((ParticleOptions)ParticleTypes.SQUID_INK, true, x, y + 1.0, z, offsetX, offsetY, offsetZ);
                }
                for (i = 0; i < 100; ++i) {
                    offsetX = level.random.nextDouble() - 0.5;
                    double offsetZ = level.random.nextDouble() - 0.5;
                    level.addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), false, x, y + 1.0, z, offsetX, 0.0, offsetZ);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

