/*
 * Decompiled with CFR 0.152.
 */
package wardentools.network.ParticulesSoundsEffects;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import wardentools.blockentity.ProtectorInvokerBlockEntity;

public class SynchronizeProtectorHeart {
    private final BlockPos pos;
    private final float health;

    public SynchronizeProtectorHeart(BlockPos pos, float health) {
        this.pos = pos;
        this.health = health;
    }

    public SynchronizeProtectorHeart(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.health = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeFloat(this.health);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> SynchronizeProtectorHeart.handlePacket(this));
        context.setPacketHandled(true);
    }

    private static void handlePacket(SynchronizeProtectorHeart msg) {
        BlockPos pos = msg.pos;
        float health = msg.health;
        try (ClientLevel level = Minecraft.getInstance().level;){
            BlockEntity blockEntity;
            if (level != null && (blockEntity = level.getBlockEntity(pos)) instanceof ProtectorInvokerBlockEntity) {
                ProtectorInvokerBlockEntity invoker = (ProtectorInvokerBlockEntity)blockEntity;
                invoker.saveHealth(health);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

