/*
 * Decompiled with CFR 0.152.
 */
package wardentools.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import wardentools.entity.custom.ContagionIncarnationEntity;

public class SyncBossEventPacket {
    private final int bossId;
    private final boolean isInBossEvent;

    public SyncBossEventPacket(int id, boolean isInBossEvent) {
        this.bossId = id;
        this.isInBossEvent = isInBossEvent;
    }

    public SyncBossEventPacket(FriendlyByteBuf buffer) {
        this.bossId = buffer.readInt();
        this.isInBossEvent = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.bossId);
        buffer.writeBoolean(this.isInBossEvent);
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            if (Minecraft.getInstance().level == null) {
                return;
            }
            ContagionIncarnationEntity bossEntity = (ContagionIncarnationEntity)Minecraft.getInstance().level.getEntity(this.bossId);
            if (bossEntity != null) {
                bossEntity.setClientInBossEvent(this.isInBossEvent);
            }
            if (!this.isInBossEvent) {
                Minecraft.getInstance().getMusicManager().stopPlaying();
            }
        });
        context.setPacketHandled(true);
    }
}

