/*
 * Decompiled with CFR 0.152.
 */
package wardentools.particle.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AbyssAmbient
extends TextureSheetParticle {
    protected AbyssAmbient(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.friction = 0.8f;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize *= 0.35f;
        this.lifetime = 200;
        this.setSpriteFromAge(spriteSet);
        this.rCol = 1.0f - level.random.nextFloat() * 0.4f;
        this.gCol = 1.0f - level.random.nextFloat() * 0.1f;
        this.bCol = 1.0f - level.random.nextFloat() * 0.1f;
    }

    public void tick() {
        super.tick();
        this.fadeOut();
    }

    private void fadeOut() {
        this.alpha = -(1.0f / (float)this.lifetime) * (float)this.age + 1.0f;
    }

    protected int getLightColor(float f) {
        BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (!this.level.hasChunkAt(blockpos)) {
            return 0;
        }
        int lightColor = LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)blockpos);
        int blockLight = lightColor >> 4 & 0xF;
        int skyLight = lightColor >> 20 & 0xF;
        blockLight = Math.min(blockLight * 2, 15);
        skyLight = Math.min(skyLight * 2, 15);
        return LightTexture.pack((int)skyLight, (int)blockLight);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType particleType, @NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new AbyssAmbient(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

