/*
 * Decompiled with CFR 0.152.
 */
package wardentools.particle.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.particle.options.ShineParticleOptions;

@OnlyIn(value=Dist.CLIENT)
public class ShineParticle
extends TextureSheetParticle {
    private final Vec3 goal;
    private final boolean emissive;
    private final boolean hasGoal;

    protected ShineParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xd, double yd, double zd, Vec3 goal, int color, boolean emissive, boolean hasGoal) {
        super(level, x, y, z, xd, yd, zd);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.friction = 0.95f;
        this.quadSize *= 0.35f;
        this.lifetime = 40;
        this.goal = goal;
        this.emissive = emissive;
        this.hasGoal = hasGoal;
        this.setSpriteFromAge(spriteSet);
        this.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    protected int getLightColor(float f) {
        return this.emissive ? 0xF000F0 : super.getLightColor(f);
    }

    public void tick() {
        double distanceSq;
        super.tick();
        if (this.hasGoal && (distanceSq = this.getPos().distanceToSqr(this.goal)) < 0.005) {
            this.remove();
            return;
        }
        this.fadeOut();
    }

    private void fadeOut() {
        this.alpha = -(1.0f / (float)this.lifetime) * (float)this.age + 1.0f;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<ShineParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ShineParticleOptions opts, @NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            ShineParticle p = new ShineParticle(level, x, y, z, this.sprites, dx, dy, dz, opts.goal(), opts.color(), opts.emissive(), opts.hasGoal());
            p.pickSprite(this.sprites);
            return p;
        }
    }
}

