/*
 * Decompiled with CFR 0.152.
 */
package wardentools.playerdata.tasks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class CompletedTasks {
    private static final String taskDataId = "completedTask";
    private final Set<Integer> tasks = new HashSet<Integer>();

    public boolean taskCompleted(int id) {
        return this.tasks.contains(id);
    }

    public void addCompletedTask(int id) {
        this.tasks.add(id);
    }

    public void removeCompletedTask(int id) {
        this.tasks.remove(id);
    }

    public Set<Integer> getAll() {
        return this.tasks;
    }

    public void copy(Set<Integer> whispers) {
        this.tasks.clear();
        this.tasks.addAll(whispers);
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.putIntArray(taskDataId, this.tasks.stream().toList());
    }

    public void loadNBTData(CompoundTag nbt) {
        this.tasks.clear();
        this.tasks.addAll(Arrays.stream(nbt.getIntArray(taskDataId)).boxed().toList());
    }
}

