/*
 * Decompiled with CFR 0.152.
 */
package wardentools.weather;

import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wardentools.weather.AbyssFogClientHandler;
import wardentools.weather.AbyssWeatherManager;
import wardentools.worldgen.dimension.ModDimensions;

@Mod.EventBusSubscriber(modid="wardentools")
public class AbyssWeatherEvent {
    public static final AbyssWeatherManager WEATHER_MANAGER = new AbyssWeatherManager();
    public static final AbyssFogClientHandler CLIENT_WEATHER = new AbyssFogClientHandler();

    @SubscribeEvent
    public static void onServerTickEvent(TickEvent.ServerTickEvent event) {
        ServerLevel abyssLevel = event.getServer().getLevel(ModDimensions.ABYSS_LEVEL_KEY);
        if (abyssLevel == null) {
            return;
        }
        WEATHER_MANAGER.tick(abyssLevel);
    }

    @SubscribeEvent
    public static void onClientLevelTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.player == null) {
            return;
        }
        CLIENT_WEATHER.updateFogDistanceOnTick((Level)minecraft.level);
    }

    @SubscribeEvent
    public static void onWeatherCommand(CommandEvent event) {
        CommandContextBuilder context = event.getParseResults().getContext();
        String command = ((ParsedCommandNode)context.getNodes().getFirst()).getNode().getName();
        if (command.equals("weather")) {
            AbyssWeatherEvent.handleWeatherCommand(context, ((CommandSourceStack)event.getParseResults().getContext().getSource()).getLevel());
        }
    }

    private static void handleWeatherCommand(CommandContextBuilder<?> context, ServerLevel level) {
        if (level.dimension() != ModDimensions.ABYSS_LEVEL_KEY) {
            return;
        }
        List nodes = context.getNodes();
        if (nodes.size() < 2) {
            return;
        }
        String subCommand = ((ParsedCommandNode)nodes.get(1)).getNode().getName();
        int duration = AbyssWeatherEvent.parseDuration(context);
        if (duration == 0) {
            switch (subCommand) {
                case "clear": {
                    WEATHER_MANAGER.weatherClear(level);
                    break;
                }
                case "rain": 
                case "thunder": {
                    WEATHER_MANAGER.startNewEvent(level);
                    break;
                }
            }
        } else {
            switch (subCommand) {
                case "clear": {
                    WEATHER_MANAGER.weatherClear(level, duration);
                    break;
                }
                case "rain": 
                case "thunder": {
                    WEATHER_MANAGER.startNewEvent(level, duration);
                    break;
                }
            }
        }
    }

    private static int parseDuration(CommandContextBuilder<?> context) {
        try {
            ParsedArgument durationArg = (ParsedArgument)context.getArguments().get("duration");
            if (durationArg != null) {
                return (Integer)durationArg.getResult();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

