/*
 * Decompiled with CFR 0.152.
 */
package wardentools.weather.lightning;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import wardentools.client.rendering.RenderingUtils;
import wardentools.weather.lightning.AbyssLightningEntity;

@OnlyIn(value=Dist.CLIENT)
public class AbyssLightningRenderer
extends EntityRenderer<AbyssLightningEntity> {
    private static final float RED = 0.1f;
    private static final float GREEN = 0.7f;
    private static final float BLUE = 0.9f;
    private static final float OPACITY = 1.0f;

    public AbyssLightningRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(AbyssLightningEntity lightningEntity, float yaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        if (lightningEntity.isLegacyLightning()) {
            this.renderLegacyLightning(lightningEntity, poseStack, bufferSource);
        } else {
            this.drawAbyssLightning(lightningEntity, poseStack, bufferSource);
        }
    }

    private void drawAbyssLightning(AbyssLightningEntity lightningEntity, PoseStack poseStack, MultiBufferSource bufferSource) {
        RandomSource randomGenerator = RandomSource.create((long)lightningEntity.seed);
        float length = 10.0f;
        float thickness = length / 15.0f;
        int depth = 4;
        int childrenNumber = randomGenerator.nextInt(2, 5);
        for (int i = 0; i < childrenNumber; ++i) {
            float angleChild = (randomGenerator.nextFloat() - 0.5f) * (float)Math.PI * 4.0f;
            float lengthChild = length * (0.4f + randomGenerator.nextFloat() * 0.4f);
            float thicknessChild = thickness * (lengthChild / length);
            float xChild = lengthChild / 2.0f * (float)Math.cos(angleChild);
            float zChild = lengthChild / 2.0f * (float)Math.sin(angleChild);
            this.drawRecursiveLightning(poseStack.last().pose(), bufferSource.getBuffer(RenderingUtils.LIGHTNING), randomGenerator, xChild, zChild, lengthChild, thicknessChild, angleChild, depth);
        }
    }

    private void drawRecursiveLightning(Matrix4f matrix, VertexConsumer vertexConsumer, RandomSource randomGenerator, float startX, float startZ, float length, float thickness, float angle, int depth) {
        this.drawAngledRectangle(matrix, vertexConsumer, startX, startZ, length, thickness, angle, 0.1f, 0.7f, 0.9f);
        if (depth == 0) {
            return;
        }
        float endX = startX + length / 2.0f * (float)Math.cos(angle);
        float endZ = startZ + length / 2.0f * (float)Math.sin(angle);
        int childrenNumber = randomGenerator.nextInt(2, 5);
        for (int i = 0; i < childrenNumber; ++i) {
            float angleChild = angle + (randomGenerator.nextFloat() - 0.5f) * (float)Math.PI / 2.0f;
            float lengthChild = length * (0.4f + randomGenerator.nextFloat() * 0.4f);
            float thicknessChild = thickness * (lengthChild / length);
            float xChild = endX + lengthChild / 2.0f * (float)Math.cos(angleChild);
            float zChild = endZ + lengthChild / 2.0f * (float)Math.sin(angleChild);
            this.drawRecursiveLightning(matrix, vertexConsumer, randomGenerator, xChild, zChild, lengthChild, thicknessChild, angleChild, depth - 1);
        }
    }

    private void drawAngledRectangle(Matrix4f matrix, VertexConsumer vertexConsumer, float centerX, float centerZ, float length, float thickness, float angle, float red, float green, float blue) {
        float halfLength = length / 2.0f;
        float halfThickness = thickness / 2.0f;
        float cosAngle = (float)Math.cos(angle);
        float sinAngle = (float)Math.sin(angle);
        float[] xOffsets = new float[]{-halfLength * cosAngle - halfThickness * sinAngle, halfLength * cosAngle - halfThickness * sinAngle, halfLength * cosAngle + halfThickness * sinAngle, -halfLength * cosAngle + halfThickness * sinAngle};
        float[] zOffsets = new float[]{-halfLength * sinAngle + halfThickness * cosAngle, halfLength * sinAngle + halfThickness * cosAngle, halfLength * sinAngle - halfThickness * cosAngle, -halfLength * sinAngle - halfThickness * cosAngle};
        for (int i = 0; i < 4; ++i) {
            int next = (i + 1) % 4;
            vertexConsumer.addVertex(matrix, centerX + xOffsets[i], 0.0f, centerZ + zOffsets[i]).setColor(red, green, blue, 1.0f);
            vertexConsumer.addVertex(matrix, centerX + xOffsets[next], 0.0f, centerZ + zOffsets[next]).setColor(red, green, blue, 1.0f);
        }
    }

    private void renderLegacyLightning(AbyssLightningEntity lightningEntity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource) {
        float[] xOffsets = new float[8];
        float[] zOffsets = new float[8];
        float previousXOffset = 0.0f;
        float previousZOffset = 0.0f;
        RandomSource randomGenerator = RandomSource.create((long)lightningEntity.seed);
        for (int segment = 7; segment >= 0; --segment) {
            xOffsets[segment] = previousXOffset;
            zOffsets[segment] = previousZOffset;
            previousXOffset += (float)(randomGenerator.nextInt(11) - 5);
            previousZOffset += (float)(randomGenerator.nextInt(11) - 5);
        }
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderingUtils.LIGHTNING);
        Matrix4f transformationMatrix = poseStack.last().pose();
        for (int branch = 0; branch < 4; ++branch) {
            RandomSource branchRandomGenerator = RandomSource.create((long)lightningEntity.seed);
            for (int pass = 0; pass < 3; ++pass) {
                int startSegment = 7;
                int endSegment = 0;
                if (pass > 0) {
                    startSegment = 7 - pass;
                }
                if (pass > 0) {
                    endSegment = startSegment - 2;
                }
                float currentXOffset = xOffsets[startSegment] - previousXOffset;
                float currentZOffset = zOffsets[startSegment] - previousZOffset;
                for (int segment = startSegment; segment >= endSegment; --segment) {
                    float nextXOffset = currentXOffset;
                    float nextZOffset = currentZOffset;
                    if (pass == 0) {
                        currentXOffset += (float)(branchRandomGenerator.nextInt(11) - 5);
                        currentZOffset += (float)(branchRandomGenerator.nextInt(11) - 5);
                    } else {
                        currentXOffset += (float)(branchRandomGenerator.nextInt(31) - 15);
                        currentZOffset += (float)(branchRandomGenerator.nextInt(31) - 15);
                    }
                    float red = 0.1f;
                    float green = 0.7f;
                    float blue = 0.9f;
                    float thicknessStart = 0.1f + (float)branch * 0.2f;
                    if (pass == 0) {
                        thicknessStart *= (float)segment * 0.1f + 1.0f;
                    }
                    float thicknessEnd = 0.1f + (float)branch * 0.2f;
                    if (pass == 0) {
                        thicknessEnd *= ((float)segment - 1.0f) * 0.1f + 1.0f;
                    }
                    AbyssLightningRenderer.drawQuad(transformationMatrix, vertexConsumer, currentXOffset, currentZOffset, segment, nextXOffset, nextZOffset, red, green, blue, thicknessStart, thicknessEnd, false, false, true, false);
                    AbyssLightningRenderer.drawQuad(transformationMatrix, vertexConsumer, currentXOffset, currentZOffset, segment, nextXOffset, nextZOffset, red, green, blue, thicknessStart, thicknessEnd, true, false, true, true);
                    AbyssLightningRenderer.drawQuad(transformationMatrix, vertexConsumer, currentXOffset, currentZOffset, segment, nextXOffset, nextZOffset, red, green, blue, thicknessStart, thicknessEnd, true, true, false, true);
                    AbyssLightningRenderer.drawQuad(transformationMatrix, vertexConsumer, currentXOffset, currentZOffset, segment, nextXOffset, nextZOffset, red, green, blue, thicknessStart, thicknessEnd, false, true, false, false);
                }
            }
        }
    }

    private static void drawQuad(Matrix4f matrix, VertexConsumer vertexConsumer, float startX, float startZ, int segment, float endX, float endZ, float red, float green, float blue, float thicknessStart, float thicknessEnd, boolean flipXStart, boolean flipZStart, boolean flipXEnd, boolean flipZEnd) {
        vertexConsumer.addVertex(matrix, startX + (flipXStart ? thicknessEnd : -thicknessEnd), (float)(segment * 16), startZ + (flipZStart ? thicknessEnd : -thicknessEnd)).setColor(red, green, blue, 1.0f);
        vertexConsumer.addVertex(matrix, endX + (flipXStart ? thicknessStart : -thicknessStart), (float)((segment + 1) * 16), endZ + (flipZStart ? thicknessStart : -thicknessStart)).setColor(red, green, blue, 1.0f);
        vertexConsumer.addVertex(matrix, endX + (flipXEnd ? thicknessStart : -thicknessStart), (float)((segment + 1) * 16), endZ + (flipZEnd ? thicknessStart : -thicknessStart)).setColor(red, green, blue, 1.0f);
        vertexConsumer.addVertex(matrix, startX + (flipXEnd ? thicknessEnd : -thicknessEnd), (float)(segment * 16), startZ + (flipZEnd ? thicknessEnd : -thicknessEnd)).setColor(red, green, blue, 1.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull AbyssLightningEntity lightning) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

