/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features.custom.cristals;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import wardentools.worldgen.features.custom.cristals.CristalVeinConfiguration;

public class CristalVein
extends Feature<CristalVeinConfiguration> {
    public CristalVein(Codec<CristalVeinConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CristalVeinConfiguration> context) {
        this.placeAndSpread(context, context.origin(), 0, null);
        return true;
    }

    public void placeAndSpread(FeaturePlaceContext<CristalVeinConfiguration> context, BlockPos currentPos, int distance, BlockPos parent) {
        context.level().setBlock(currentPos, ((CristalVeinConfiguration)context.config()).cristalBlock, 3);
        for (Direction direction : Direction.values()) {
            if (!context.level().getBlockState(currentPos.relative(direction)).isAir() || context.level().getRandom().nextInt(0, ((CristalVeinConfiguration)context.config()).cristalBudProbability) != 0) continue;
            context.level().setBlock(currentPos.relative(direction), (BlockState)((CristalVeinConfiguration)context.config()).cristalBud.setValue((Property)BlockStateProperties.FACING, (Comparable)direction), 3);
        }
        if (distance < ((CristalVeinConfiguration)context.config()).maxLength) {
            List<BlockPos> neighbors = CristalVein.getRandomNonAirNeighbors(context, currentPos, parent);
            for (BlockPos neighbor : neighbors) {
                this.placeAndSpread(context, neighbor, distance + 1, parent);
            }
        }
    }

    public static List<BlockPos> getRandomNonAirNeighbors(FeaturePlaceContext<CristalVeinConfiguration> context, BlockPos pos, BlockPos parent) {
        ArrayList<BlockPos> validNeighbors = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos neighborPos = pos.offset(x, y, z);
                    BlockState neighborState = context.level().getBlockState(neighborPos);
                    if (neighborState.isAir() || neighborState.is(((CristalVeinConfiguration)context.config()).cristalBud.getBlock()) || !BlockPredicate.solid().test((Object)context.level(), (Object)neighborPos) || !CristalVein.isExposedToAir(context, neighborPos) || !CristalVein.farEnoughFromParent(parent, neighborPos)) continue;
                    validNeighbors.add(neighborPos);
                }
            }
        }
        Collections.shuffle(validNeighbors, new Random());
        int number_to_return = context.level().getRandom().nextInt(((CristalVeinConfiguration)context.config()).spreadFactor / 2, ((CristalVeinConfiguration)context.config()).spreadFactor * 3 / 2);
        return validNeighbors.stream().limit(number_to_return).toList();
    }

    public static boolean farEnoughFromParent(BlockPos parent, BlockPos neighbor) {
        if (parent == null) {
            return true;
        }
        return Math.abs(parent.getX() - neighbor.getX()) > 1 && Math.abs(parent.getY() - neighbor.getY()) > 1 && Math.abs(parent.getZ() - neighbor.getZ()) > 1;
    }

    public static boolean isExposedToAir(FeaturePlaceContext<CristalVeinConfiguration> context, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!context.level().getBlockState(pos.relative(direction)).isAir()) continue;
            return true;
        }
        return false;
    }
}

