/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.tree.custom;

import com.google.common.base.Function;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import wardentools.worldgen.tree.ModTrunkPlacerTypes;

public class WhitetreeTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<WhitetreeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(whitetreeTrunkPlacerInstance -> WhitetreeTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)whitetreeTrunkPlacerInstance).apply((Applicative)whitetreeTrunkPlacerInstance, WhitetreeTrunkPlacer::new));

    public WhitetreeTrunkPlacer(int baseHeight, int pHeightRandA, int pHeightRandB) {
        super(baseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.WHITETREE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        int i;
        WhitetreeTrunkPlacer.setDirtAt((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.below(), (TreeConfiguration)pConfig);
        ArrayList<BlockPos> listTrunk = new ArrayList<BlockPos>();
        ArrayList listTrunkNS = new ArrayList();
        ArrayList listTrunkWE = new ArrayList();
        ArrayList<FoliagePlacer.FoliageAttachment> foliagePositions = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int treeHeight = pFreeTreeHeight;
        boolean doubleTrunk = false;
        if (treeHeight > 9) {
            doubleTrunk = true;
        }
        for (i = 0; i < treeHeight; ++i) {
            listTrunk.add(pPos.above(i));
            if (doubleTrunk) {
                listTrunk.add(pPos.offset(1, i, 0));
                listTrunk.add(pPos.offset(0, i, 1));
                listTrunk.add(pPos.offset(1, i, 1));
            }
            if (i < Math.round(treeHeight / 3) || (i - Math.round(treeHeight / 3)) % 3 != 0) continue;
            int lengthBranches = Math.round((treeHeight - i) / 3);
            List<List<BlockPos>> listBranches = this.branches(pPos.above(i), lengthBranches, doubleTrunk);
            listTrunkNS.addAll(listBranches.get(0));
            listTrunkWE.addAll(listBranches.get(1));
        }
        foliagePositions.add(new FoliagePlacer.FoliageAttachment(pPos, 0, doubleTrunk));
        for (i = 0; i < listTrunk.size(); ++i) {
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)listTrunk.get(i), pConfig);
        }
        for (i = 0; i < listTrunkNS.size(); ++i) {
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)listTrunkNS.get(i), pConfig, Direction.EAST);
        }
        for (i = 0; i < listTrunkWE.size(); ++i) {
            this.placeLog(pLevel, pBlockSetter, pRandom, (BlockPos)listTrunkWE.get(i), pConfig, Direction.NORTH);
        }
        return foliagePositions;
    }

    private List<List<BlockPos>> branches(BlockPos startPos, int length, boolean doubleTrunk) {
        ArrayList<BlockPos> listTrunkNS = new ArrayList<BlockPos>();
        ArrayList<BlockPos> listTrunkWE = new ArrayList<BlockPos>();
        int offsetDouble = doubleTrunk ? 1 : 0;
        for (int i = 1; i <= length; ++i) {
            listTrunkNS.add(startPos.offset(-i, 0, 0));
            listTrunkNS.add(startPos.offset(i + offsetDouble, 0, 0));
            listTrunkWE.add(startPos.offset(0, 0, i + offsetDouble));
            listTrunkWE.add(startPos.offset(0, 0, -i));
            if (!doubleTrunk) continue;
            listTrunkNS.add(startPos.offset(-i, 0, 1));
            listTrunkNS.add(startPos.offset(i + 1, 0, 1));
            listTrunkWE.add(startPos.offset(1, 0, -i));
            listTrunkWE.add(startPos.offset(1, 0, i + 1));
        }
        ArrayList<List<BlockPos>> result = new ArrayList<List<BlockPos>>();
        result.add(listTrunkNS);
        result.add(listTrunkWE);
        return result;
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pos, TreeConfiguration pConfig, Direction direction) {
        Function orientLog = logState -> {
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                return (BlockState)logState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z);
            }
            if (direction == Direction.EAST || direction == Direction.WEST) {
                return (BlockState)logState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X);
            }
            return logState;
        };
        return this.placeLog(pLevel, pBlockSetter, pRandom, pos, pConfig, (Function<BlockState, BlockState>)orientLog);
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pos, TreeConfiguration pConfig, Function<BlockState, BlockState> orientLog) {
        if (this.validTreePos(pLevel, pos)) {
            pBlockSetter.accept(pos, (BlockState)orientLog.apply((Object)pConfig.trunkProvider.getState(pRandom, pos)));
            return true;
        }
        return false;
    }

    protected boolean placeLog(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pos, TreeConfiguration pConfig) {
        return this.placeLog(pLevel, pBlockSetter, pRandom, pos, pConfig, Direction.UP);
    }
}

