/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.GolemStoneBlockEntity;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.CrystalGolemEntity;
import wardentools.misc.Crystal;

public class GolemStoneBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final MapCodec<GolemStoneBlock> CODEC = GolemStoneBlock.simpleCodec(GolemStoneBlock::new);
    public static final EnumProperty<Crystal> CRYSTAL;
    public static final BooleanProperty HAS_SCULK;
    public static final BooleanProperty HAS_SPAWNED_GOLEM;

    public GolemStoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(CRYSTAL, (Comparable)((Object)Crystal.getDefault()))).setValue((Property)HAS_SCULK, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_SPAWNED_GOLEM, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACING, CRYSTAL, HAS_SCULK, HAS_SPAWNED_GOLEM});
    }

    public static void placeGolem(Level level, BlockPos pos, BlockState state) {
        CrystalGolemEntity golem = new CrystalGolemEntity(ModEntities.CRYSTAL_GOLEM.get(), level);
        float yRot = ((Direction)state.getValue((Property)FACING)).toYRot();
        golem.setSyncedYRot(yRot);
        golem.moveTo((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5, yRot, 0.0f);
        golem.setCrystalType((Crystal)((Object)state.getValue(CRYSTAL)));
        golem.setGolemStonePos(pos);
        golem.setState(level.getRandom().nextBoolean() ? CrystalGolemEntity.GolemState.DEACTIVATED_1 : CrystalGolemEntity.GolemState.DEACTIVATED_2);
        golem.setSculk((Boolean)state.getValue((Property)HAS_SCULK));
        level.addFreshEntity((Entity)golem);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide ? null : (level0, pos0, state0, blockEntity) -> ((GolemStoneBlockEntity)blockEntity).tick();
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new GolemStoneBlockEntity(blockPos, blockState);
    }

    static {
        HAS_SCULK = BooleanProperty.create((String)"has_sculk");
        HAS_SPAWNED_GOLEM = BooleanProperty.create((String)"has_spawned_golem");
        CRYSTAL = EnumProperty.create((String)"crystal_index", Crystal.class);
    }
}

