/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block.depthvines;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.block.depthvines.DepthVines;
import wardentools.items.ItemRegistry;

public class DepthVinesBlock
extends GrowingPlantHeadBlock
implements BonemealableBlock,
DepthVines {
    public static final MapCodec<CaveVinesBlock> CODEC = DepthVinesBlock.simpleCodec(CaveVinesBlock::new);
    private static final float CHANCE_OF_BERRIES_ON_GROWTH = 0.11f;

    @NotNull
    public MapCodec<CaveVinesBlock> codec() {
        return CODEC;
    }

    public DepthVinesBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false, 0.1);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected int getBlocksToGrowWhenBonemealed(@NotNull RandomSource random) {
        return 1;
    }

    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    @NotNull
    protected Block getBodyBlock() {
        return (Block)BlockRegistry.DEPTH_VINES_PLANT.get();
    }

    @NotNull
    protected BlockState updateBodyAfterConvertedFromHead(BlockState state, BlockState myState) {
        return (BlockState)myState.setValue((Property)BERRIES, (Comparable)((Boolean)state.getValue((Property)BERRIES)));
    }

    @NotNull
    protected BlockState getGrowIntoState(@NotNull BlockState state, @NotNull RandomSource random) {
        return (BlockState)super.getGrowIntoState(state, random).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(random.nextFloat() < 0.11f));
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader reader, @NotNull BlockPos pos, @NotNull BlockState state) {
        return new ItemStack((ItemLike)ItemRegistry.DEPTH_BERRIES.get());
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        return DepthVines.use((Entity)player, state, level, pos);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{BERRIES});
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader levelReader, @NotNull BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BERRIES) == false;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return DepthVines.canHangBelow(level.getBlockState(pos.above()), level, pos.above()) || super.canSurvive(state, level, pos);
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }
}

