/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block.sculktendril;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class TendrilNode {
    private final BlockPos position;
    private final ArrayList<TendrilNode> children;
    @Nullable
    private TendrilNode parent = null;
    private int depth = 1;

    public TendrilNode(BlockPos position, @Nullable TendrilNode parent, TendrilNode ... children) {
        this.position = position;
        this.children = new ArrayList<TendrilNode>(List.of(children));
        if (parent != null) {
            this.parent = parent;
            this.depth = parent.getDepth() + 1;
        }
    }

    public TendrilNode(BlockPos position, int depth) {
        this.position = position;
        this.depth = depth;
        this.children = new ArrayList();
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public List<TendrilNode> getChildren() {
        return this.children;
    }

    public void addChild(TendrilNode child) {
        if (this.children.contains(child)) {
            return;
        }
        this.children.add(child);
        child.setDepth(this.depth + 1);
    }

    @Nullable
    public TendrilNode getParent() {
        return this.parent;
    }

    public void setParent(@Nullable TendrilNode parent) {
        this.parent = parent;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.put("position", (Tag)TendrilNode.blockPosToTag(this.position));
        tag.putInt("depth", this.depth);
        if (this.parent != null) {
            tag.put("parent", (Tag)TendrilNode.blockPosToTag(this.parent.getPosition()));
        }
        return tag;
    }

    public static CompoundTag blockPosToTag(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", pos.getX());
        tag.putInt("y", pos.getY());
        tag.putInt("z", pos.getZ());
        return tag;
    }

    public static BlockPos blockPosFromTag(CompoundTag tag) {
        return new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
    }
}

