/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import wardentools.blockentity.SculkTendrilBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class SculkTendrilBlockRenderer
implements BlockEntityRenderer<SculkTendrilBlockEntity> {
    private static final ResourceLocation SCULK = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/item/sculk_tendril_block.png");
    private static final Map<Direction, Quaternionf> DIRECTION_ROTATIONS = Map.of(Direction.NORTH, new Quaternionf(), Direction.SOUTH, new Quaternionf().rotateY((float)Math.PI), Direction.WEST, new Quaternionf().rotateY(1.5707964f), Direction.EAST, new Quaternionf().rotateY(-1.5707964f), Direction.UP, new Quaternionf().rotateX(-1.5707964f), Direction.DOWN, new Quaternionf().rotateX(1.5707964f));
    private int cachedWidth = 0;
    private CubeModel cachedModel;
    private CubeModel cachedComplementaryModel;

    public SculkTendrilBlockRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    @NotNull
    public AABB getRenderBoundingBox(SculkTendrilBlockEntity entity) {
        return new AABB((double)entity.getBlockPos().getX() - 1.0, (double)entity.getBlockPos().getY() - 1.0, (double)entity.getBlockPos().getZ() - 1.0, (double)entity.getBlockPos().getX() + 1.0, (double)entity.getBlockPos().getY() + 1.0, (double)entity.getBlockPos().getZ() + 1.0);
    }

    public void render(@NotNull SculkTendrilBlockEntity blockEntity, float v, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = blockEntity.getBlockPos();
        if (this.cachedModel == null || this.cachedComplementaryModel == null || this.cachedWidth != blockEntity.getWidth()) {
            this.cachedWidth = blockEntity.getWidth();
            this.createCubeModels(blockEntity);
        }
        this.renderMiddle(level, pos, poseStack, buffer, packedOverlay);
        for (Direction direction : Direction.values()) {
            if (!blockEntity.getConnection(direction)) continue;
            this.renderComplementaryInDirection(level, pos, direction, poseStack, buffer, packedOverlay);
        }
    }

    private void renderMiddle(Level level, BlockPos pos, PoseStack poseStack, MultiBufferSource buffer, int packedOverlay) {
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)SCULK));
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        this.cachedModel.render(poseStack, vertexConsumer, LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos)), packedOverlay);
        poseStack.popPose();
    }

    private void renderComplementaryInDirection(Level level, BlockPos pos, Direction direction, PoseStack poseStack, MultiBufferSource buffer, int packedOverlay) {
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)SCULK));
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        float centralHalfSize = (float)this.cachedWidth / 32.0f;
        int branchLength = 8 - this.cachedWidth / 2;
        float branchHalfLength = (float)branchLength / 32.0f;
        float branchCenterOffset = centralHalfSize + branchHalfLength;
        poseStack.translate((float)direction.getStepX() * branchCenterOffset, (float)direction.getStepY() * branchCenterOffset, (float)direction.getStepZ() * branchCenterOffset);
        poseStack.mulPose(DIRECTION_ROTATIONS.get(direction));
        this.cachedComplementaryModel.render(poseStack, vertexConsumer, LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos)), packedOverlay);
        poseStack.popPose();
    }

    private void createCubeModels(SculkTendrilBlockEntity blockEntity) {
        this.cachedWidth = blockEntity.getWidth();
        if (this.cachedWidth == 0) {
            return;
        }
        this.cachedModel = new CubeModel(CubeModel.createBodyLayer(this.cachedWidth, this.cachedWidth, this.cachedWidth).bakeRoot());
        int branchLength = 8 - this.cachedWidth / 2;
        this.cachedComplementaryModel = new CubeModel(CubeModel.createBodyLayer(this.cachedWidth, this.cachedWidth, branchLength).bakeRoot());
    }

    public boolean shouldRender(@NotNull SculkTendrilBlockEntity tendrilBlockEntity, @NotNull Vec3 cameraPos) {
        double dz;
        double dy;
        BlockPos pos = tendrilBlockEntity.getBlockPos();
        double dx = (double)pos.getX() - cameraPos.x;
        return dx * dx + (dy = (double)pos.getY() - cameraPos.y) * dy + (dz = (double)pos.getZ() - cameraPos.z) * dz < 4096.0;
    }

    private static class CubeModel
    extends Model {
        private final ModelPart root;

        public CubeModel(ModelPart parts) {
            super(RenderType::entitySolid);
            this.root = parts;
        }

        public static LayerDefinition createBodyLayer(int x, int y, int z) {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(-8, -8).addBox(-((float)x) / 2.0f, -((float)y) / 2.0f, -((float)z) / 2.0f, (float)x, (float)y, (float)z), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
        }

        public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
            this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
        }

        public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay) {
            this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        }
    }
}

