/*
 * Decompiled with CFR 0.152.
 */
package wardentools.client.color;

public class ColorUtils {
    public static int rgbToHex(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int addOpaqueAlpha(int rgb) {
        return ColorUtils.addAlpha(rgb, 255);
    }

    public static int addAlpha(int rgb, int alpha) {
        return (alpha & 0xFF) << 24 | rgb & 0xFFFFFF;
    }

    public static int getRed(int rgb) {
        return rgb >>> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >>> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static int lerpColor(int colorA, int colorB, float t) {
        int rA = ColorUtils.getRed(colorA);
        int gA = ColorUtils.getGreen(colorA);
        int bA = ColorUtils.getBlue(colorA);
        int rB = ColorUtils.getRed(colorB);
        int gB = ColorUtils.getGreen(colorB);
        int bB = ColorUtils.getBlue(colorB);
        int r = (int)((float)rA + (float)(rB - rA) * t);
        int g = (int)((float)gA + (float)(gB - gA) * t);
        int b = (int)((float)bA + (float)(bB - bA) * t);
        return ColorUtils.rgbToHex(r, g, b);
    }

    public static class Alpha {
        public static int getAlpha(int argb) {
            return argb >>> 24 & 0xFF;
        }

        public static int getRed(int argb) {
            return argb >>> 16 & 0xFF;
        }

        public static int getGreen(int argb) {
            return argb >>> 8 & 0xFF;
        }

        public static int getBlue(int argb) {
            return argb & 0xFF;
        }
    }
}

