/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen.loot;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import wardentools.items.ItemRegistry;

public class ModAdvancementLootTables
implements LootTableSubProvider {
    public static final ResourceKey<LootTable> WIND_JOURNAL_LT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"advancements/wind_journal"));
    private final Map<ResourceKey<LootTable>, LootTable.Builder> lootTables = new HashMap<ResourceKey<LootTable>, LootTable.Builder>();
    protected final HolderLookup.Provider registries;

    public ModAdvancementLootTables(HolderLookup.Provider provider) {
        this.registries = provider;
    }

    private void generate() {
        this.addSimpleLootTable(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.WIND_JOURNAL.get()))), WIND_JOURNAL_LT);
    }

    private void addSimpleLootTable(LootPool.Builder lootTable, ResourceKey<LootTable> key) {
        this.lootTables.put(key, LootTable.lootTable().withPool(lootTable));
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        this.generate();
        for (Map.Entry<ResourceKey<LootTable>, LootTable.Builder> entry : this.lootTables.entrySet()) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }
}

