/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen.utils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import wardentools.datagen.ModRecipesGenerator;
import wardentools.items.recipe.RadianceCatalystRecipe;

public class RadianceCatalystRecipeBuilder {
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private static final String recipe_type_id = "radiance_catalyst";
    private final Ingredient input;
    private final ItemStack result;
    private final int energyCost;

    public RadianceCatalystRecipeBuilder(Ingredient input, ItemStack result, int energyCost) {
        this.input = input;
        this.result = result;
        this.energyCost = energyCost;
    }

    public static RadianceCatalystRecipeBuilder catalyst(Ingredient input, ItemStack result, int energyCost) {
        return new RadianceCatalystRecipeBuilder(input, result, energyCost);
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        if (this.input.getItems().length == 0) {
            throw new IllegalStateException("No input item for recipe " + String.valueOf(id));
        }
        this.criteria.put("has_item", ModRecipesGenerator.hasItem((ItemLike)Arrays.stream(this.input.getItems()).toList().getFirst().getItem()));
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        Objects.requireNonNull(advancementBuilder);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        output.accept(id, (Recipe)new RadianceCatalystRecipe(this.input, this.result, this.energyCost), advancementBuilder.build(id.withPrefix("recipes/radiance_catalyst/")));
    }
}

