/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.animations.ProtectorAnimation;
import wardentools.entity.custom.ProtectorEntity;

@OnlyIn(value=Dist.CLIENT)
public class Protector
extends HierarchicalModel<ProtectorEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"protector"), "main");
    private final ModelParts parts;

    public Protector(ModelPart root) {
        ModelPart FULL = root.getChild("FULL");
        ModelPart BODY = FULL.getChild("BODY");
        ModelPart HEAD = BODY.getChild("HEAD");
        ModelPart EAR_L = HEAD.getChild("EAR_L");
        ModelPart EAR_R = HEAD.getChild("EAR_R");
        ModelPart TORSO = BODY.getChild("TORSO");
        ModelPart ARM_L = TORSO.getChild("ARM_L");
        ModelPart ARM_R = TORSO.getChild("ARM_R");
        ModelPart LEG_R = FULL.getChild("LEG_R");
        ModelPart LEG_L = FULL.getChild("LEG_L");
        this.parts = new ModelParts(FULL, BODY, HEAD, TORSO, ARM_R, ARM_L, LEG_R, LEG_L, EAR_R, EAR_L);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition FULL = partdefinition.addOrReplaceChild("FULL", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition BODY = FULL.addOrReplaceChild("BODY", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition HEAD = BODY.addOrReplaceChild("HEAD", CubeListBuilder.create().texOffs(0, 32).addBox(-8.0f, -16.0f, -5.0f, 16.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-21.0f, (float)0.0f));
        PartDefinition EAR_L = HEAD.addOrReplaceChild("EAR_L", CubeListBuilder.create().texOffs(59, 6).addBox(0.0f, -7.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-12.0f, (float)0.0f));
        PartDefinition EAR_R = HEAD.addOrReplaceChild("EAR_R", CubeListBuilder.create().texOffs(58, 37).addBox(-10.0f, -7.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-12.0f, (float)0.0f));
        PartDefinition TORSO = BODY.addOrReplaceChild("TORSO", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, 0.0f, -5.0f, 18.0f, 21.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-21.0f, (float)0.0f));
        PartDefinition ARM_L = TORSO.addOrReplaceChild("ARM_L", CubeListBuilder.create().texOffs(44, 50).addBox(0.0f, -3.0f, -4.0f, 8.0f, 28.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.0f, (float)4.0f, (float)0.0f));
        PartDefinition ARM_R = TORSO.addOrReplaceChild("ARM_R", CubeListBuilder.create().texOffs(0, 58).addBox(-8.0f, -3.0f, -4.0f, 8.0f, 28.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-9.0f, (float)4.0f, (float)0.0f));
        PartDefinition LEG_R = FULL.addOrReplaceChild("LEG_R", CubeListBuilder.create().texOffs(76, 77).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)11.0f, (float)0.0f));
        PartDefinition LEG_L = FULL.addOrReplaceChild("LEG_L", CubeListBuilder.create().texOffs(76, 49).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        this.parts.FULL().render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
    }

    @NotNull
    public ModelPart root() {
        return this.parts.FULL();
    }

    public void setupAnim(ProtectorEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (!entity.isSpawning() || entity.isDispawning()) {
            if (!entity.isSprinting()) {
                this.animateWalk(ProtectorAnimation.walking, limbSwing, limbSwingAmount, 1.0f, 2.5f);
            } else {
                this.animateWalk(ProtectorAnimation.running, limbSwing, limbSwingAmount, 1.0f, 2.5f);
            }
            this.animate(entity.earTickle, ProtectorAnimation.earsTickle, ageInTicks);
            this.animate(entity.attackAnimationState, ProtectorAnimation.hit, ageInTicks);
            this.parts.HEAD().xRot += headPitch * ((float)Math.PI / 180);
            this.parts.HEAD().yRot += netHeadYaw * ((float)Math.PI / 180);
        }
        this.animate(entity.spawning, ProtectorAnimation.spawn, ageInTicks);
        this.animate(entity.dispawning, ProtectorAnimation.dispawn, ageInTicks);
    }

    private record ModelParts(ModelPart FULL, ModelPart BODY, ModelPart HEAD, ModelPart TORSO, ModelPart ARM_R, ModelPart ARM_L, ModelPart LEG_R, ModelPart LEG_L, ModelPart EAR_R, ModelPart EAR_L) {
    }
}

