/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.client.Shadow;
import wardentools.entity.client.ShadowEmissiveLayer;
import wardentools.entity.custom.ShadowEntity;

@OnlyIn(value=Dist.CLIENT)
public class ShadowRenderer
extends MobRenderer<ShadowEntity, Shadow> {
    private static final ResourceLocation HUMANOID_SHADOW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/entity/shadow.png");
    private static final ResourceLocation GENERIC_SHADOW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/entity/generic_shadow.png");

    public ShadowRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new Shadow(context.bakeLayer(Shadow.LAYER_LOCATION)), 0.2f);
        this.addLayer(new ShadowEmissiveLayer((RenderLayerParent<ShadowEntity, Shadow>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ShadowEntity shadow) {
        return shadow.getMimicEntity() == null ? HUMANOID_SHADOW_TEXTURE : GENERIC_SHADOW_TEXTURE;
    }

    public void render(@NotNull ShadowEntity shadow, float yaw, float partialTick, @NotNull PoseStack stack, @NotNull MultiBufferSource buffer, int packedLight) {
        super.render((LivingEntity)shadow, yaw, partialTick, stack, buffer, packedLight);
    }

    protected float getBob(@NotNull ShadowEntity shadow, float ageInTick) {
        if (shadow.getGetBobFunction() == null) {
            return super.getBob((LivingEntity)shadow, ageInTick);
        }
        return shadow.getGetBobFunction().getBob(shadow.getMimicEntity(), ageInTick);
    }

    protected void scale(@NotNull ShadowEntity shadow, @NotNull PoseStack poseStack, float v) {
        if (shadow.getScaleFunction() == null) {
            super.scale((LivingEntity)shadow, poseStack, v);
        } else {
            shadow.getScaleFunction().scale(shadow.getMimicEntity(), poseStack, v);
        }
    }
}

