/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.interfaces.CorruptionMonster;
import wardentools.entity.utils.goal.ClimbParasyteGoal;
import wardentools.particle.ParticleRegistry;
import wardentools.sounds.ModSounds;

public class ParasyteEntity
extends CorruptionMonster {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.defineId(ParasyteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState idleAnimation = new AnimationState();

    public ParasyteEntity(EntityType<? extends Monster> entity, Level level) {
        super(entity, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new ClimbParasyteGoal(this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FLYING_SPEED, 0.01);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(CLIMBING, (Object)false);
    }

    public boolean isClimbing() {
        return (Boolean)this.entityData.get(CLIMBING);
    }

    public void setClimbing(boolean climbing) {
        this.entityData.set(CLIMBING, (Object)climbing);
    }

    public void tick() {
        this.idleAnimation.animateWhen(!this.walkAnimation.isMoving(), this.tickCount);
        if (this.level().isClientSide && this.tickCount % 5 == this.level().getRandom().nextInt(5)) {
            Vec3 particlePos = this.getPosition(1.0f);
            this.level().addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), particlePos.x, particlePos.y, particlePos.z, (double)(this.level().getRandom().nextFloat() * 0.04f), (double)(this.level().getRandom().nextFloat() * 0.1f), (double)(this.level().getRandom().nextFloat() * 0.04f));
        }
        super.tick();
    }

    public static boolean canSpawn(EntityType<ParasyteEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos).isAir();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.playSound(ModSounds.PARASYTE_STEP.get(), this.getSoundVolume(), 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return ModSounds.PARASYTE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.PARASYTE_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }
}

