/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.interfaces;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.interfaces.CorruptionMonster;
import wardentools.entity.utils.ClientMimicRenderingUtils;
import wardentools.entity.utils.RenderToBufferFunction;
import wardentools.entity.utils.ScaleFunction;
import wardentools.entity.utils.SetUpAnimFunction;
import wardentools.entity.utils.getBobFunction;

public class MimicEntity
extends CorruptionMonster {
    private LivingEntity mimicEntity = null;
    private static final EntityDataAccessor<Integer> MIMIC_ENTITY_ID = SynchedEntityData.defineId(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected MimicEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public void tick() {
        Entity entity;
        int id;
        super.tick();
        if (this.level().isClientSide && (id = ((Integer)this.entityData.get(MIMIC_ENTITY_ID)).intValue()) != -1 && (entity = this.level().getEntity(id)) instanceof LivingEntity) {
            this.mimicEntity = (LivingEntity)entity;
        }
        this.updateBoundingBoxSize();
    }

    private void updateBoundingBoxSize() {
        if (this.mimicEntity != null) {
            double width = this.mimicEntity.getBbWidth();
            double height = this.mimicEntity.getBbHeight();
            double depth = this.mimicEntity.getBbWidth();
            double centerX = this.getX();
            double centerY = this.getY();
            double centerZ = this.getZ();
            AABB newBox = new AABB(centerX - width / 2.0, centerY, centerZ - depth / 2.0, centerX + width / 2.0, centerY + height, centerZ + depth / 2.0);
            this.setBoundingBox(newBox);
        }
    }

    public boolean isBaby() {
        if (this.mimicEntity == null) {
            return super.isBaby();
        }
        return this.mimicEntity.isBaby();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(MIMIC_ENTITY_ID, (Object)-1);
    }

    public double getEyeY() {
        if (this.mimicEntity == null) {
            return super.getEyeY();
        }
        return this.mimicEntity.getEyeY();
    }

    public RenderToBufferFunction getRenderToBufferFunction() {
        if (!this.level().isClientSide || this.mimicEntity == null) {
            return null;
        }
        return ClientMimicRenderingUtils.getRenderToBufferFunction(this.mimicEntity);
    }

    public <T extends LivingEntity> SetUpAnimFunction<T> getSetUpAnimFunction() {
        if (this.mimicEntity == null) {
            return null;
        }
        return ClientMimicRenderingUtils.getSetUpAnimFunction(this.mimicEntity);
    }

    public <T extends LivingEntity> getBobFunction<T> getGetBobFunction() {
        if (!this.level().isClientSide || this.mimicEntity == null) {
            return null;
        }
        return ClientMimicRenderingUtils.getGetBobFunction(this.mimicEntity);
    }

    public <T extends LivingEntity> ScaleFunction<T> getScaleFunction() {
        if (!this.level().isClientSide || this.mimicEntity == null) {
            return null;
        }
        return ClientMimicRenderingUtils.getScaleFunction(this.mimicEntity);
    }

    public LivingEntity getMimicEntity() {
        return this.mimicEntity;
    }

    public void setMimicEntity(LivingEntity mimicEntity) {
        this.mimicEntity = mimicEntity;
        this.entityData.set(MIMIC_ENTITY_ID, (Object)mimicEntity.getId());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.mimicEntity != null) {
            tag.putInt("MimicEntityId", this.mimicEntity.getId());
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("MimicEntityId")) {
            int id = tag.getInt("MimicEntityId");
            this.entityData.set(MIMIC_ENTITY_ID, (Object)id);
        }
    }
}

