/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wardentools.entity.custom.NoctilureEntity;

@OnlyIn(value=Dist.CLIENT)
public class ClientNoctilureRidingControl {
    public static void handlePlayerControl(NoctilureEntity noctilure) {
        if (noctilure.getWantsToLand()) {
            noctilure.setWantsToLand(false);
        }
        if (noctilure.getWantsToTakeOff()) {
            noctilure.setWantsToTakeOff(false);
        }
        if (Minecraft.getInstance().options.keyDown.isDown() && noctilure.getIsFlying() && noctilure.getHeightAboveGround() <= 1.0) {
            noctilure.land();
        }
        if (noctilure.getIsFlying()) {
            if (Minecraft.getInstance().options.keySprint.isDown()) {
                if (Minecraft.getInstance().options.keyUp.isDown()) {
                    noctilure.lowerEnergy(10);
                }
                if (noctilure.energyWasZero) {
                    noctilure.setFlightSprinting(noctilure.getSprintEnergy() > 10);
                } else {
                    noctilure.setFlightSprinting(noctilure.getSprintEnergy() > 0);
                }
            } else {
                noctilure.setFlightSprinting(false);
            }
            if (noctilure.getSprintEnergy() < 2000) {
                if (!Minecraft.getInstance().options.keyUp.isDown()) {
                    noctilure.increaseEnergy(2);
                } else if (!Minecraft.getInstance().options.keySprint.isDown()) {
                    noctilure.increaseEnergy(1);
                }
            }
        } else if (noctilure.getSprintEnergy() < 2000) {
            noctilure.increaseEnergy(20);
        }
    }

    public static void noctilureMovement(NoctilureEntity noctilure, Player player) {
        if (noctilure.getIsFlying() && Minecraft.getInstance().options.keyUp.isDown()) {
            noctilure.flyingTravel(player.getViewVector(1.0f).scale(noctilure.getFlightSprinting() ? (double)1.1f : 0.5).scale(noctilure.isInWater() ? (double)0.1f : 1.0));
        }
    }
}

