/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ContagionIncarnationEntity;
import wardentools.entity.custom.ParasyteEntity;
import wardentools.network.payloads.special_effects.IncarnationEmergeSound;
import wardentools.network.payloads.special_effects.IncarnationSonicStrikeSound;

public class IncarnationSonicStrikeAttackGoal
extends Goal {
    private static final int SCREAM_SOUND_DELAY = 20;
    private static final int SONIC_SOUND_ADVANCE_TICK = 23;
    private static final int MAX_PARASYTES = 25;
    private static final float PARASYTE_RADIUS_CHECK = 30.0f;
    private static final int PARASYTES_TO_SPAWN = 10;
    private static final float PARASYTE_SPAWN_RADIUS = 5.0f;
    private static final int PLAYER_BLINDNESS_DURATION = 100;
    private static final float PLAYER_BLINDNESS_RADIUS = 30.0f;
    private final ContagionIncarnationEntity incarnation;
    @Nullable
    private LivingEntity targetCached;

    public IncarnationSonicStrikeAttackGoal(ContagionIncarnationEntity incarnation) {
        this.incarnation = incarnation;
    }

    public void start() {
        this.incarnation.getNavigation().stop();
        this.targetCached = this.incarnation.getTarget();
        this.incarnation.setTarget(null);
        this.incarnation.setDeltaMovement(Vec3.ZERO);
    }

    private boolean cancelParasyteSummoning() {
        ServerLevel serverLevel = (ServerLevel)this.incarnation.level();
        long parasyteCount = serverLevel.getEntitiesOfClass(ParasyteEntity.class, this.incarnation.getBoundingBox().inflate(30.0)).stream().filter(entity -> entity.getType() == ModEntities.PARASYTE.get()).count();
        return (int)parasyteCount > 25;
    }

    public void tick() {
        Level level = this.incarnation.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.incarnation.getSonicStrikeTick() == 80) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)serverLevel.getChunkAt(this.incarnation.blockPosition()).getPos(), (CustomPacketPayload)new IncarnationEmergeSound(this.incarnation.position().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (this.incarnation.getSonicStrikeTick() == 45) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)serverLevel.getChunkAt(this.incarnation.blockPosition()).getPos(), (CustomPacketPayload)new IncarnationSonicStrikeSound(this.incarnation.position().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (this.incarnation.getSonicStrikeTick() == 22) {
                this.applyBlindnessAndSummonParasyte();
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void applyBlindnessAndSummonParasyte() {
        ServerLevel serverLevel = (ServerLevel)this.incarnation.level();
        AABB area = this.incarnation.getBoundingBox().inflate(30.0);
        for (Player player : serverLevel.getEntitiesOfClass(Player.class, area)) {
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
        }
        if (!this.cancelParasyteSummoning()) {
            this.spawnParasytesAroundIncarnation(serverLevel, ModEntities.PARASYTE.get());
        }
    }

    private void spawnParasytesAroundIncarnation(ServerLevel level, EntityType<?> entityType) {
        for (int i = 0; i < 10; ++i) {
            double angle = (double)i * 36.0;
            double xOffset = Math.cos(Math.toRadians(angle)) * 5.0;
            double zOffset = Math.sin(Math.toRadians(angle)) * 5.0;
            Entity entity = entityType.create((Level)level);
            if (entity == null) continue;
            entity.moveTo(this.incarnation.getX() + xOffset, this.incarnation.getY(), this.incarnation.getZ() + zOffset, 0.0f, 0.0f);
            level.addFreshEntity(entity);
        }
    }

    public boolean canUse() {
        return this.incarnation.getSonicStrikeTick() > 0;
    }

    public boolean canContinueToUse() {
        return this.incarnation.getSonicStrikeTick() > 0;
    }

    public void stop() {
        this.incarnation.setTarget(this.targetCached);
    }
}

