/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events.gameevents;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import wardentools.effect.ModEffects;

@EventBusSubscriber(modid="wardentools", value={Dist.CLIENT})
public class CorruptedOverlayRenderer {
    private static final Map<UUID, Integer> effectTotalDurations = new HashMap<UUID, Integer>();
    private static final ResourceLocation CORRUPTED_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/misc/corruption_outline_screen.png");
    private static final float blurDurationTick = 200.0f;
    private static final float glitterPulsation = 0.04f;
    private static final float transparentMax = 0.9f;

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.hasEffect(ModEffects.CORRUPTED) && !player.hasEffect(ModEffects.PURIFIED)) {
            MobEffectInstance effectInstance = player.getEffect(ModEffects.CORRUPTED);
            if (effectInstance == null) {
                return;
            }
            int duration = effectInstance.getDuration();
            int totalDuration = effectTotalDurations.getOrDefault(player.getUUID(), duration);
            if (!effectTotalDurations.containsKey(player.getUUID())) {
                totalDuration = duration * 100;
            }
            int elapsedDuration = Math.max(totalDuration - duration, 0);
            float alpha = Math.min((float)elapsedDuration / 200.0f, 1.0f);
            float color_intensity = (float)elapsedDuration > 200.0f ? Math.abs((float)Math.sin(((float)duration - 200.0f) * 0.04f)) : 1.0f;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)color_intensity, (float)color_intensity, (float)color_intensity, (float)(alpha * 0.9f));
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int screenWidth = guiGraphics.guiWidth();
            int screenHeight = guiGraphics.guiHeight();
            guiGraphics.blit(CORRUPTED_OVERLAY, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Added event) {
        LivingEntity entity;
        if (event.getEffectInstance() == null) {
            return;
        }
        if (event.getEffectInstance().getEffect() == ModEffects.CORRUPTED && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!effectTotalDurations.containsKey(player.getUUID()) || !player.hasEffect(ModEffects.CORRUPTED)) {
                effectTotalDurations.put(player.getUUID(), event.getEffectInstance().getDuration());
            } else if (player.getEffect(ModEffects.CORRUPTED) != null) {
                int totalDuration = event.getEffectInstance().getDuration() + effectTotalDurations.get(player.getUUID()) - player.getEffect(ModEffects.CORRUPTED).getDuration();
                effectTotalDurations.put(player.getUUID(), totalDuration);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity entity;
        if (event.getEffectInstance() == null) {
            return;
        }
        if (event.getEffectInstance().getEffect() == ModEffects.CORRUPTED && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            effectTotalDurations.remove(player.getUUID());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity entity;
        if (event.getEffectInstance() == null) {
            return;
        }
        if (event.getEffectInstance().getEffect() == ModEffects.CORRUPTED && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            effectTotalDurations.remove(player.getUUID());
        }
    }
}

