/*
 * Decompiled with CFR 0.152.
 */
package wardentools.gui.menu;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.blockentity.RadianceCatalystBlockEntity;
import wardentools.gui.MenuRegistry;
import wardentools.gui.menu.slot.RadianceFragmentSlot;

public class RadianceCatalystMenu
extends AbstractContainerMenu {
    private final RadianceCatalystBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;
    private final ContainerData data;

    public RadianceCatalystMenu(int containerId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(containerId, playerInventory, playerInventory.player.level().getBlockEntity(additionalData.readBlockPos()), (ContainerData)new SimpleContainerData(5));
    }

    public RadianceCatalystMenu(int containerId, Inventory playerInventory, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)MenuRegistry.RADIANCE_CATALYST_MENU.get(), containerId);
        RadianceCatalystBlockEntity be;
        if (!(blockEntity instanceof RadianceCatalystBlockEntity)) {
            throw new IllegalStateException("Incorrect block entity class (%s) passed into RadianceCatalystMenu!".formatted(blockEntity.getClass().getCanonicalName()));
        }
        this.blockEntity = be = (RadianceCatalystBlockEntity)blockEntity;
        this.levelAccess = ContainerLevelAccess.create((Level)Objects.requireNonNull(blockEntity.getLevel()), (BlockPos)blockEntity.getBlockPos());
        this.data = data;
        this.createPlayerHotbar(playerInventory);
        this.createPlayerInventory(playerInventory);
        this.createBlockEntityInventory(be);
        this.addDataSlots(data);
    }

    private void createBlockEntityInventory(RadianceCatalystBlockEntity be) {
        ItemStackHandler inventory = be.getInventory();
        if (inventory == null) {
            return;
        }
        this.addSlot((Slot)new RadianceFragmentSlot((IItemHandler)inventory, 0, 44, 36));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)inventory, 1, 111, 19));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)inventory, 2, 111, 54));
    }

    private void createPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, 9 + column + row * 9, 8 + column * 18, 84 + row * 18));
            }
        }
    }

    private void createPlayerHotbar(Inventory playerInventory) {
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, 8 + column * 18, 142));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot fromSlot = this.getSlot(index);
        ItemStack fromStack = fromSlot.getItem();
        if (fromStack.getCount() <= 0) {
            fromSlot.set(ItemStack.EMPTY);
        }
        if (!fromSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack copyFromStack = fromStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(fromStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 39) {
            if (!this.moveItemStackTo(fromStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.err.println("Invalid slot bossId: " + index);
            return ItemStack.EMPTY;
        }
        fromSlot.setChanged();
        fromSlot.onTake(player, fromStack);
        return copyFromStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return RadianceCatalystMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)BlockRegistry.RADIANCE_CATALYST.get()));
    }

    public RadianceCatalystBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getEnergy() {
        return this.data.get(0);
    }

    public int getMaxEnergy() {
        return this.data.get(1);
    }

    public int getBurnTime() {
        return this.data.get(2);
    }

    public int getMaxBurnTime() {
        return this.data.get(3);
    }

    public int getPurifyingTime() {
        return this.data.get(4);
    }
}

