/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import wardentools.sounds.ModSounds;

public class ModJukeBoxSongsGenerator {
    public static final ResourceKey<JukeboxSong> ABYSS = ModJukeBoxSongsGenerator.create("abyss_theme");
    public static final ResourceKey<JukeboxSong> INCARNATION = ModJukeBoxSongsGenerator.create("incarnation_theme");
    public static final ResourceKey<JukeboxSong> DEEPFOREST = ModJukeBoxSongsGenerator.create("deepforest_music");
    public static final ResourceKey<JukeboxSong> WHITEFOREST = ModJukeBoxSongsGenerator.create("whiteforest_music");
    public static final ResourceKey<JukeboxSong> REFLECTION = ModJukeBoxSongsGenerator.create("reflection_of_the_past_music");

    public static void bootstrap(BootstrapContext<JukeboxSong> context) {
        ModJukeBoxSongsGenerator.register(context, ABYSS, ModSounds.getAbyssThemeMusicDisc(), 171, 1);
        ModJukeBoxSongsGenerator.register(context, INCARNATION, ModSounds.getIncarnationThemeMusicDisc(), 126, 2);
        ModJukeBoxSongsGenerator.register(context, DEEPFOREST, ModSounds.getDeepForestMusicDisc(), 121, 3);
        ModJukeBoxSongsGenerator.register(context, WHITEFOREST, ModSounds.getWhiteForestMusicDisc(), 103, 4);
        ModJukeBoxSongsGenerator.register(context, REFLECTION, ModSounds.getReflectionMusicDisc(), 159, 5);
    }

    private static void register(BootstrapContext<JukeboxSong> context, ResourceKey<JukeboxSong> song, Holder.Reference<SoundEvent> soundEventReference, int lengthInSeconds, int comparatorOutput) {
        context.register(song, (Object)new JukeboxSong(soundEventReference, (Component)Component.translatable((String)Util.makeDescriptionId((String)"jukebox_song", (ResourceLocation)song.location())), (float)lengthInSeconds, comparatorOutput));
    }

    private static ResourceKey<JukeboxSong> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)name));
    }
}

