/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import wardentools.effect.ModEffects;
import wardentools.items.clientutils.WardenHeartFoilManager;
import wardentools.misc.WardenLaserAttack;
import wardentools.network.payloads.special_effects.WardenLaserParticleSound;

public class WardenHeartItem
extends Item {
    private final WardenLaserAttack laserAttack = new WardenLaserAttack();
    private static final int laserLength = 14;

    public WardenHeartItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (WardenHeartItem.isCorruptionVessel(player)) {
                player.getCooldowns().addCooldown((Item)this, 120);
                long gameTime = serverLevel.getGameTime();
                Vec3 startPosition = player.position().add(0.0, 1.0, 0.0);
                Vec3 direction = player.getLookAngle();
                this.laserAttack.tick(serverLevel, player, gameTime, startPosition, direction, 14);
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)serverLevel.getChunkAt(player.getOnPos()).getPos(), (CustomPacketPayload)new WardenLaserParticleSound(startPosition.toVector3f(), direction.toVector3f(), 14), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return InteractionResultHolder.success((Object)player.getItemInHand(interactionHand));
            }
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(interactionHand));
    }

    private static boolean isCorruptionVessel(Player player) {
        if (player == null) {
            return false;
        }
        return player.getEffect(ModEffects.CORRUPTION_VESSEL) != null;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return WardenHeartFoilManager.isFoil();
    }
}

