/*
 * Decompiled with CFR 0.152.
 */
package wardentools.mixin;

import java.util.ArrayList;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BookViewScreen.BookAccess.class})
public class BookAccessMixin {
    @Inject(method={"fromItem"}, at={@At(value="RETURN")}, cancellable=true)
    private static void fromItemMixin(ItemStack stack, CallbackInfoReturnable<BookViewScreen.BookAccess> cir) {
        BookViewScreen.BookAccess access = (BookViewScreen.BookAccess)cir.getReturnValue();
        if (access == null) {
            return;
        }
        ArrayList<Object> newPages = new ArrayList<Object>();
        boolean modified = false;
        for (Component page : access.pages()) {
            String raw = page.getString().trim();
            if (raw.startsWith("book.wardentools.")) {
                newPages.add(Component.translatable((String)raw));
                modified = true;
                continue;
            }
            newPages.add(page);
        }
        if (modified) {
            cir.setReturnValue((Object)new BookViewScreen.BookAccess(newPages));
        }
    }
}

