/*
 * Decompiled with CFR 0.152.
 */
package wardentools.network;

import com.mojang.logging.LogUtils;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import wardentools.block.BlockRegistry;
import wardentools.blockentity.ProtectorInvokerBlockEntity;
import wardentools.blockentity.RadianceCatalystBlockEntity;
import wardentools.gui.winscreen.CustomWinScreen;
import wardentools.misc.wind.WindWhispers;
import wardentools.network.IClientPayloadHandler;
import wardentools.network.payloads.SendFogStateToClient;
import wardentools.network.payloads.ShowWinScreen;
import wardentools.network.payloads.SwitchCamera;
import wardentools.network.payloads.TeleportPlayerTo;
import wardentools.network.payloads.datasync.SyncDataTaskToClient;
import wardentools.network.payloads.datasync.SyncKnownWhisperToClient;
import wardentools.network.payloads.special_effects.AncientLaboratoryGateSound;
import wardentools.network.payloads.special_effects.ContagionParticleExplosion;
import wardentools.network.payloads.special_effects.IncarnationEmergeSound;
import wardentools.network.payloads.special_effects.IncarnationScreamSound;
import wardentools.network.payloads.special_effects.IncarnationSonicStrikeSound;
import wardentools.network.payloads.special_effects.LivingSproutBurst;
import wardentools.network.payloads.special_effects.ParticleDarktreeFenceDestroy;
import wardentools.network.payloads.special_effects.ParticleShineExplosion;
import wardentools.network.payloads.special_effects.ProtectorHeartSynchronize;
import wardentools.network.payloads.special_effects.RadianceCatalystChargedParticleSound;
import wardentools.network.payloads.special_effects.RadianceCatalystChargingParticleSound;
import wardentools.network.payloads.special_effects.RadianceCatalystPurifyingParticleSound;
import wardentools.network.payloads.special_effects.RadianceParticleExplosion;
import wardentools.network.payloads.special_effects.ThemeIncarnationStart;
import wardentools.network.payloads.special_effects.ThemeIncarnationStop;
import wardentools.network.payloads.special_effects.WardenDeathParticle;
import wardentools.network.payloads.special_effects.WardenLaserParticleSound;
import wardentools.network.payloads.special_effects.WindWhisperSendToClient;
import wardentools.network.payloads.special_effects.WindWhisperSound;
import wardentools.particle.ParticleRegistry;
import wardentools.particle.options.ShineParticleOptions;
import wardentools.playerdata.ModDataAttachments;
import wardentools.playerdata.serializables.CompletedTasks;
import wardentools.playerdata.serializables.KnownWindWhispers;
import wardentools.sounds.ModMusics;
import wardentools.sounds.ModSounds;
import wardentools.weather.AbyssWeatherEventClient;

@OnlyIn(value=Dist.CLIENT)
public class ClientPayloadHandler
implements IClientPayloadHandler {
    private final BlockParticleOption FENCE_PARTICLE = new BlockParticleOption(ParticleTypes.BLOCK, ((Block)BlockRegistry.DARKTREE_FENCE.get()).defaultBlockState());

    @Override
    public void showWinScreen(ShowWinScreen msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            CustomWinScreen winScreen = new CustomWinScreen(true, () -> {
                PacketDistributor.sendToServer((CustomPacketPayload)new TeleportPlayerTo(msg.respawnPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                minecraft.setScreen((Screen)null);
            });
            winScreen.init(minecraft, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight());
            minecraft.setScreen((Screen)winScreen);
        }, ctx);
    }

    @Override
    public void updateFogDistance(SendFogStateToClient msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> AbyssWeatherEventClient.CLIENT_WEATHER.setIsStorming(msg.isStorming()), ctx);
    }

    @Override
    public void switchCamera(SwitchCamera msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            if (ctx.player().level().isClientSide()) {
                if (Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK) {
                    Minecraft.getInstance().options.setCameraType(CameraType.FIRST_PERSON);
                } else if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
                    Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
                }
            }
        }, ctx);
    }

    @Override
    public void syncDataTask(SyncDataTaskToClient msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            CompletedTasks data = (CompletedTasks)ctx.player().getData(ModDataAttachments.COMPLETED_TASKS);
            if (msg.remove()) {
                data.removeCompletedTask(msg.taskId());
            } else {
                data.addCompletedTask(msg.taskId());
            }
            ctx.player().setData(ModDataAttachments.COMPLETED_TASKS, (Object)data);
        }, ctx);
    }

    @Override
    public void syncKnownWhisper(SyncKnownWhisperToClient msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            KnownWindWhispers data = (KnownWindWhispers)ctx.player().getData(ModDataAttachments.KNOWN_WIND_WHISPERS);
            for (int i : msg.whisperIds()) {
                data.addKnownWhisper(i);
            }
            ctx.player().setData(ModDataAttachments.KNOWN_WIND_WHISPERS, (Object)data);
        }, ctx);
    }

    @Override
    public void ancientLaboratoryGateSound(AncientLaboratoryGateSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Vector3f source = msg.pos();
            Level level = ctx.player().level();
            BlockPos pos = new BlockPos((int)source.x(), (int)source.y(), (int)source.z());
            level.playLocalSound(pos, ModSounds.ANCIENT_LABORATORY_GATE_CLOSING.get(), SoundSource.BLOCKS, 2.5f, 1.0f, false);
        }, ctx);
    }

    @Override
    public void incarnationEmergeSound(IncarnationEmergeSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            SoundEvent soundEvent = ModSounds.CONTAGION_INCARNATION_EMERGE.get();
            Level level = ctx.player().level();
            level.playLocalSound((double)msg.pos().x, (double)msg.pos().y, (double)msg.pos().z, soundEvent, SoundSource.HOSTILE, 7.0f, 1.0f, false);
        }, ctx);
    }

    @Override
    public void incarnationScreamSound(IncarnationScreamSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Vector3f source = msg.pos();
            Level level = ctx.player().level();
            BlockPos pos = new BlockPos((int)source.x(), (int)source.y(), (int)source.z());
            level.playLocalSound(pos, ModSounds.CONTAGION_INCARNATION_SCREAM.get(), SoundSource.HOSTILE, 2.0f, 1.0f, false);
        }, ctx);
    }

    @Override
    public void incarnationSonicStrikeSound(IncarnationSonicStrikeSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Vector3f source = msg.pos();
            Level level = ctx.player().level();
            BlockPos pos = new BlockPos((int)source.x(), (int)source.y(), (int)source.z());
            level.playLocalSound(pos, ModSounds.SONIC_STRIKE.get(), SoundSource.HOSTILE, 4.0f, 1.0f, false);
        }, ctx);
    }

    @Override
    public void contagionParticleExplosion(ContagionParticleExplosion msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            this.particleExplosion(level, msg.pos(), msg.radius(), msg.speed(), msg.particleNumber(), (ParticleOptions)ParticleRegistry.CORRUPTION.get(), msg.implosion());
        }, ctx);
    }

    @Override
    public void particleDarktreeFenceDestroy(ParticleDarktreeFenceDestroy msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            for (int i = 0; i < 8; ++i) {
                double offsetX = (level.random.nextDouble() - 0.5) * 0.05;
                double offsetY = (level.random.nextDouble() - 0.5) * 0.05;
                double offsetZ = (level.random.nextDouble() - 0.5) * 0.05;
                level.addParticle((ParticleOptions)this.FENCE_PARTICLE, (double)msg.pos().x, (double)msg.pos().y, (double)msg.pos().z, offsetX, offsetY, offsetZ);
            }
        }, ctx);
    }

    @Override
    public void radianceCatalystChargedParticleSound(RadianceCatalystChargedParticleSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            int number = level.random.nextInt(3) + 1;
            for (int i = 0; i < number; ++i) {
                double offsetX = (level.random.nextDouble() - 0.5) * 0.2;
                double offsetY = (level.random.nextDouble() - 0.5) * 0.2;
                double offsetZ = (level.random.nextDouble() - 0.5) * 0.2;
                level.addParticle(RadianceCatalystBlockEntity.PARTICLE, true, (double)msg.pos().x, (double)msg.pos().y, (double)msg.pos().z, offsetX, offsetY, offsetZ);
            }
            level.playLocalSound((double)msg.pos().x, (double)msg.pos().y, (double)msg.pos().z, SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }, ctx);
    }

    @Override
    public void radianceCatalystChargingParticleSound(RadianceCatalystChargingParticleSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            double speed = 0.06666666666666667;
            double offsetX = (level.random.nextDouble() - 0.5) * 2.0;
            double offsetY = (level.random.nextDouble() - 0.5) * 2.0;
            double offsetZ = (level.random.nextDouble() - 0.5) * 2.0;
            level.addParticle(RadianceCatalystBlockEntity.PARTICLE, true, (double)msg.pos().x + offsetX, (double)msg.pos().y + offsetY, (double)msg.pos().z + offsetZ, -offsetX * speed, -offsetY * speed, -offsetZ * speed);
            if (level.random.nextInt(20) == 1) {
                level.playLocalSound((double)msg.pos().x, (double)msg.pos().y, (double)msg.pos().z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }, ctx);
    }

    @Override
    public void radianceCatalystPurifyingParticleSound(RadianceCatalystPurifyingParticleSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            int number = level.random.nextInt(3) + 1;
            for (int i = 0; i < number; ++i) {
                double offsetX = (level.random.nextDouble() - 0.5) * 0.2;
                double offsetY = (level.random.nextDouble() - 0.5) * 0.2;
                double offsetZ = (level.random.nextDouble() - 0.5) * 0.2;
                level.addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), true, (double)msg.pos().x, (double)msg.pos().y, (double)msg.pos().z, offsetX, offsetY, offsetZ);
            }
            level.playLocalSound((double)msg.pos().x, (double)msg.pos().y, (double)msg.pos().z, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }, ctx);
    }

    @Override
    public void radianceParticleExplosion(RadianceParticleExplosion msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            this.particleExplosion(level, msg.pos(), msg.radius(), msg.speed(), msg.particleNumber(), (ParticleOptions)ParticleRegistry.RADIANCE.get(), msg.implosion());
        }, ctx);
    }

    @Override
    public void wardenDeathParticle(WardenDeathParticle msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            this.particleExplosion(level, msg.pos(), 0.1f, 0.6f, 100, (ParticleOptions)ParticleTypes.SQUID_INK, false);
            for (int i = 0; i < 100; ++i) {
                double offsetX = level.random.nextDouble() - 0.5;
                double offsetZ = level.random.nextDouble() - 0.5;
                level.addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), false, (double)msg.pos().x, (double)msg.pos().y, (double)msg.pos().z, offsetX, 0.0, offsetZ);
            }
        }, ctx);
    }

    @Override
    public void themeIncarnationStart(ThemeIncarnationStart msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Minecraft.getInstance().getMusicManager().stopPlaying();
            Minecraft.getInstance().getMusicManager().startPlaying(ModMusics.INCARNATION_THEME);
        }, ctx);
    }

    @Override
    public void themeIncarnationStop(ThemeIncarnationStop msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> Minecraft.getInstance().getMusicManager().stopPlaying(ModMusics.INCARNATION_THEME), ctx);
    }

    @Override
    public void protectorHeartSynchronize(ProtectorHeartSynchronize msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            BlockPos pos;
            Level level = ctx.player().level();
            BlockEntity patt0$temp = level.getBlockEntity(pos = new BlockPos((int)msg.pos().x, (int)msg.pos().y, (int)msg.pos().z));
            if (patt0$temp instanceof ProtectorInvokerBlockEntity) {
                ProtectorInvokerBlockEntity invoker = (ProtectorInvokerBlockEntity)patt0$temp;
                invoker.saveHealth(msg.health());
            }
        }, ctx);
    }

    @Override
    public void wardenLaserParticleSound(WardenLaserParticleSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            Vector3f startPosition = msg.startPos();
            Vector3f direction = msg.direction();
            level.playLocalSound((double)startPosition.x, (double)startPosition.y, (double)startPosition.z, SoundEvents.WARDEN_SONIC_BOOM, SoundSource.HOSTILE, 1.0f, 1.0f, false);
            for (int i = 1; i < Mth.floor((float)direction.length()) + msg.laserLength(); ++i) {
                Vector3f particlePosition = startPosition.add((Vector3fc)direction.mul((float)i));
                level.addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, false, (double)particlePosition.x, (double)particlePosition.y, (double)particlePosition.z, 0.0, 0.0, 0.0);
            }
        }, ctx);
    }

    @Override
    public void sendWhisperToClient(WindWhisperSendToClient msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            if (ctx.player().level().isClientSide()) {
                WindWhispers.sendRandomWhisperToPlayer(ctx.player());
            }
        }, ctx);
    }

    @Override
    public void windWhisperSound(WindWhisperSound msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            if (ctx.player().level().isClientSide()) {
                ctx.player().playSound(ModSounds.WIND_WHISPERS.get(), 5.0f, (ctx.player().getRandom().nextFloat() - ctx.player().getRandom().nextFloat()) * 0.2f + 1.0f);
            }
        }, ctx);
    }

    @Override
    public void particleShineExplosion(ParticleShineExplosion msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            if (ctx.player().level().isClientSide()) {
                Level level = ctx.player().level();
                ShineParticleOptions particles = new ShineParticleOptions(Vec3.ZERO, msg.color(), true, false);
                this.particleExplosion(level, msg.pos(), msg.radius(), msg.speed(), msg.particleNumber(), particles, false);
            }
        }, ctx);
    }

    @Override
    public void livingSproutBurst(LivingSproutBurst msg, IPayloadContext ctx) {
        this.handleDataOnNetwork(() -> {
            Level level = ctx.player().level();
            BlockPos pos = new BlockPos((int)msg.pos().x, (int)msg.pos().y, (int)msg.pos().z);
            for (int i = 0; i < 10; ++i) {
                double offsetX = (level.random.nextFloat() - 0.5f) * 0.2f;
                double offsetY = level.random.nextFloat() * 0.2f;
                double offsetZ = (level.random.nextFloat() - 0.5f) * 0.2f;
                level.addParticle((ParticleOptions)ParticleTypes.WHITE_ASH, (double)((float)pos.getX() + 0.5f) + offsetX, (double)((float)pos.getY() + 0.5f) + offsetY, (double)((float)pos.getZ() + 0.5f) + offsetZ, 0.0, (double)0.05f, 0.0);
            }
            this.particleExplosion(level, msg.pos(), 0.3f, 0.1f, 40, (ParticleOptions)ParticleRegistry.CORRUPTION.get(), false);
        }, ctx);
    }

    private void particleExplosion(Level level, Vector3f pos, float radius, float speed, int particleNumber, ParticleOptions particle, boolean implosion) {
        for (int i = 0; i < particleNumber; ++i) {
            float offsetZ;
            float offsetY;
            double theta = (double)level.random.nextFloat() * Math.PI * 2.0;
            double phi = Math.acos(1.0f - 2.0f * level.random.nextFloat());
            float offsetX = (float)((double)radius * Math.sin(phi) * Math.cos(theta));
            float norm = (float)Math.sqrt(offsetX * offsetX + (offsetY = (float)((double)radius * Math.cos(phi))) * offsetY + (offsetZ = (float)((double)radius * Math.sin(phi) * Math.sin(theta))) * offsetZ);
            if (norm == 0.0f) continue;
            float adjustedSpeed = speed / norm * ((level.random.nextFloat() + 4.0f) / 5.0f);
            if (implosion) {
                adjustedSpeed = -adjustedSpeed;
            }
            level.addParticle(particle, (double)(pos.x + offsetX), (double)(pos.y + offsetY), (double)(pos.z + offsetZ), (double)(offsetX * adjustedSpeed), (double)(offsetY * adjustedSpeed), (double)(offsetZ * adjustedSpeed));
        }
    }

    private void handleDataOnNetwork(Runnable run, IPayloadContext ctx) {
        ctx.enqueueWork(run).exceptionally(e -> {
            LogUtils.getLogger().error("Dive Into the Abyss networking failed{}", (Object)e.getMessage());
            ctx.disconnect((Component)Component.literal((String)"Dive Into the Abyss networking failed"));
            return null;
        });
    }
}

