/*
 * Decompiled with CFR 0.152.
 */
package wardentools.particle.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.particle.options.GlyphParticleRotatingOptions;

@OnlyIn(value=Dist.CLIENT)
public class GlyphParticleRotating
extends TextureSheetParticle {
    private static final int AV_SPRITE_DURATION = 20;
    private final Vec3 center;
    private final Vec3 axis;
    private final boolean emissive;
    private final SpriteSet sprites;
    private final double angularVelocity;
    private double totalAngle = 0.0;
    private final double radius;
    private final Vec3 initialDir;

    protected GlyphParticleRotating(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xd, double yd, double zd, Vec3 center, Vec3 axis, int lifetime, int color, boolean emissive, double angularVelocity) {
        super(level, x, y, z, xd, yd, zd);
        this.sprites = spriteSet;
        this.friction = 1.0f;
        this.hasPhysics = false;
        this.quadSize = 0.0525f;
        this.lifetime = lifetime;
        this.center = center;
        this.axis = axis.normalize();
        this.emissive = emissive;
        this.angularVelocity = angularVelocity;
        Vec3 offset = new Vec3(this.x, this.y, this.z).subtract(center);
        this.radius = offset.length();
        this.initialDir = offset.normalize();
        this.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public int getLightColor(float f) {
        return this.emissive ? 0xF000F0 : super.getLightColor(f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
            return;
        }
        this.totalAngle += this.angularVelocity;
        Vec3 rotated = GlyphParticleRotating.rotateAroundAxis(this.initialDir.scale(this.radius), this.axis, (float)this.totalAngle);
        Vec3 worldPos = this.center.add(rotated);
        this.setPos(worldPos.x, worldPos.y, worldPos.z);
        if (this.random.nextInt(20) == 0) {
            this.setRandomSprite();
        }
        this.fadeOut();
    }

    private void fadeOut() {
        this.alpha = -(1.0f / (float)this.lifetime) * (float)this.age + 1.0f;
    }

    private void setRandomSprite() {
        this.pickSprite(this.sprites);
        this.setSpriteFromAge(this.sprites);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private static Vec3 rotateAroundAxis(Vec3 pos, Vec3 axis, float angle) {
        axis = axis.normalize();
        double half = (double)angle / 2.0;
        double a = Mth.cos((float)((float)half));
        double s = Mth.sin((float)((float)half));
        Vec3 b = axis.scale(s);
        return pos.add(b.cross(pos.scale(a)).add(b.cross(b.cross(pos))).scale(2.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<GlyphParticleRotatingOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(GlyphParticleRotatingOptions opts, @NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            GlyphParticleRotating p = new GlyphParticleRotating(level, x, y, z, this.sprites, dx, dy, dz, opts.center(), opts.axis(), opts.lifetime(), opts.color(), opts.emissive(), opts.angularVelocity());
            p.pickSprite(this.sprites);
            return p;
        }
    }
}

