/*
 * Decompiled with CFR 0.152.
 */
package wardentools.playerdata.serializables;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class CompletedTasks
implements INBTSerializable<CompoundTag> {
    private static final String taskDataId = "task_list";
    private final Set<Integer> tasks = new HashSet<Integer>();

    public boolean taskCompleted(int id) {
        return this.tasks.contains(id);
    }

    public void addCompletedTask(int id) {
        this.tasks.add(id);
    }

    public void removeCompletedTask(int id) {
        this.tasks.remove(id);
    }

    public Set<Integer> getAll() {
        return this.tasks;
    }

    public void copy(CompletedTasks other) {
        this.tasks.clear();
        this.tasks.addAll(other.getAll());
    }

    public void copy(Set<Integer> whispers) {
        this.tasks.clear();
        this.tasks.addAll(whispers);
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        int[] arr = this.tasks.stream().mapToInt(Integer::intValue).toArray();
        tag.putIntArray(taskDataId, arr);
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        int[] arr = tag.getIntArray(taskDataId);
        this.tasks.clear();
        for (int i : arr) {
            this.tasks.add(i);
        }
    }
}

