/*
 * Decompiled with CFR 0.152.
 */
package wardentools.playerdata.serializables;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class KnownWindWhispers
implements INBTSerializable<CompoundTag> {
    private static final String taskDataId = "known_wind_whispers";
    private final Set<Integer> whispers = new HashSet<Integer>();

    public boolean whisperKnown(int id) {
        return this.whispers.contains(id);
    }

    public void addKnownWhisper(int id) {
        this.whispers.add(id);
    }

    public void removeKnownWhisper(int id) {
        this.whispers.remove(id);
    }

    public Set<Integer> getAll() {
        return this.whispers;
    }

    public int[] getAllAsArray() {
        return this.whispers.stream().mapToInt(Integer::intValue).toArray();
    }

    public void copy(KnownWindWhispers other) {
        this.whispers.clear();
        this.whispers.addAll(other.getAll());
    }

    public void copy(Set<Integer> whispers) {
        this.whispers.clear();
        this.whispers.addAll(whispers);
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        int[] arr = this.whispers.stream().mapToInt(Integer::intValue).toArray();
        tag.putIntArray(taskDataId, arr);
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        int[] arr = tag.getIntArray(taskDataId);
        this.whispers.clear();
        for (int i : arr) {
            this.whispers.add(i);
        }
    }
}

