/*
 * Decompiled with CFR 0.152.
 */
package wardentools.weather;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import wardentools.network.payloads.RequestStormStateFromServer;
import wardentools.weather.AbyssFogEvent;

@OnlyIn(value=Dist.CLIENT)
public class AbyssFogClientHandler {
    private static final float FOG_INTERPOLATION_SPEED = 0.05f;
    private float currentFogDistance = AbyssFogClientHandler.getMaxFogDistance();
    private boolean isStorming = false;
    private int lastTime = 0;
    private int lastUpdate = 0;
    private static final int UPDATE_INTERVAL = 20;

    public void updateFogDistanceOnTick(Level level) {
        if (this.lastUpdate == 0) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RequestStormStateFromServer(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.lastUpdate = 20;
        } else {
            --this.lastUpdate;
        }
        float targetFogDistance1 = this.isStorming ? 20.0f : AbyssFogClientHandler.getMaxFogDistance();
        LocalPlayer player = Minecraft.getInstance().player;
        float targetFogDistance = player != null ? (AbyssFogEvent.isPlayerOutside((Player)player) ? targetFogDistance1 : AbyssFogClientHandler.getMaxFogDistance()) : targetFogDistance1;
        if ((int)level.getGameTime() != this.lastTime) {
            this.currentFogDistance = targetFogDistance * 0.05f + this.currentFogDistance * 0.95f;
            this.lastTime = (int)level.getGameTime();
        }
    }

    public static float getMaxFogDistance() {
        if (Minecraft.getInstance() == null || Minecraft.getInstance().options == null) {
            return 256.0f;
        }
        return ((Integer)Minecraft.getInstance().options.renderDistance().get()).floatValue() * 16.0f;
    }

    public float currentFogDistance() {
        return this.currentFogDistance;
    }

    public void setIsStorming(boolean isStorming) {
        this.isStorming = isStorming;
    }
}

