/*
 * Decompiled with CFR 0.152.
 */
package wardentools.weather;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.ModEntities;
import wardentools.network.payloads.SendFogStateToClient;
import wardentools.network.payloads.special_effects.WindWhisperSound;
import wardentools.weather.lightning.AbyssLightningEntity;

public class AbyssWeatherManager {
    private static final int MAX_EVENT_DURATION = 6000;
    private static final int MIN_EVENT_DURATION = 3000;
    private static final int MAX_TICK_BETWEEN_EVENT = 48000;
    private static final int MIN_TICK_BETWEEN_EVENT = 24000;
    private static final int AVERAGE_TICK_BETWEEN_LIGHTNING_PER_CHUNK = 5000;
    public static final float MIN_FOG_DISTANCE = 20.0f;
    private int weatherTimer = RandomSource.create().nextInt(24000, 48000);
    private int timeSinceStormBegin = 0;
    private boolean isStorming = false;
    private Set<ChunkPos> loadedChunks = new HashSet<ChunkPos>();
    private static final Component stormMessage = Component.translatable((String)"message.wardentools.wind.storm");
    private static final Component stormEndMessage = Component.translatable((String)"message.wardentools.wind.storm_end");

    public void tick(@NotNull ServerLevel level) {
        if (!level.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
            return;
        }
        --this.weatherTimer;
        if (this.isStorming) {
            this.stormTick(level);
        }
        if (this.weatherTimer <= 0 && this.anyWeatherEventActive()) {
            this.weatherClear(level, level.random.nextInt(24000, 48000));
        } else if (this.weatherTimer <= 0) {
            this.startNewEvent(level);
        }
    }

    private boolean anyWeatherEventActive() {
        return this.isStorming;
    }

    public void weatherClear(ServerLevel level) {
        this.weatherClear(level, level.random.nextInt(24000, 48000));
    }

    public void weatherClear(ServerLevel level, int duration) {
        this.weatherTimer = duration;
        this.stopStorm(level);
    }

    public void startNewEvent(ServerLevel level) {
        this.startNewStorm(level);
    }

    public void startNewEvent(ServerLevel level, int duration) {
        this.weatherTimer = duration;
        this.startNewEvent(level);
    }

    public void startNewStorm(ServerLevel level) {
        this.weatherTimer = level.random.nextInt(3000, 6000);
        this.onStartStorm(level);
    }

    private void updateLoadedChunks(ServerLevel level) {
        this.loadedChunks = new HashSet<ChunkPos>();
        for (ServerPlayer player : level.players()) {
            if (player.level() != level) continue;
            ChunkPos playerChunk = new ChunkPos(player.blockPosition());
            int viewDistance = 8;
            for (int dx = -viewDistance; dx <= viewDistance; ++dx) {
                for (int dz = -viewDistance; dz <= viewDistance; ++dz) {
                    this.loadedChunks.add(new ChunkPos(playerChunk.x + dx, playerChunk.z + dz));
                }
            }
        }
    }

    private void stormTick(ServerLevel level) {
        ++this.timeSinceStormBegin;
        if (this.timeSinceStormBegin % 20 == 0) {
            this.updateLoadedChunks(level);
        }
        for (ChunkPos chunkPos : this.loadedChunks) {
            if (level.random.nextInt(5000) != 0) continue;
            this.addLightningInChunk(level, chunkPos);
        }
    }

    private void addLightningInChunk(ServerLevel level, ChunkPos chunkPos) {
        AbyssLightningEntity lightning = (AbyssLightningEntity)ModEntities.ABYSS_LIGHTNING.get().create((Level)level);
        if (lightning != null) {
            RandomSource random = level.random;
            int x = (chunkPos.x << 4) + random.nextInt(16);
            int z = (chunkPos.z << 4) + random.nextInt(16);
            if (level.random.nextInt(10) == 0) {
                lightning.setIsLegacyLightning(true);
            }
            int y = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, new BlockPos(x, 0, z)).getY() + (lightning.isLegacyLightning() ? 0 : 60);
            lightning.moveTo(x, y, z);
            if (level.random.nextInt(10) == 0) {
                lightning.setIsLegacyLightning(true);
            }
            level.addFreshEntity((Entity)lightning);
        }
    }

    public void onStartStorm(ServerLevel level) {
        this.isStorming = true;
        this.sendServerFogDistanceToAllClients();
        level.players().stream().filter(player -> player.level() == level).forEach(player -> {
            player.sendSystemMessage(stormMessage);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WindWhisperSound(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    private void stopStorm(ServerLevel level) {
        this.isStorming = false;
        this.sendServerFogDistanceToAllClients();
        level.players().stream().filter(player -> player.level() == level).forEach(player -> {
            player.sendSystemMessage(stormEndMessage);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WindWhisperSound(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        this.timeSinceStormBegin = 0;
    }

    public void sendServerFogDistanceToAllClients() {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SendFogStateToClient(this.isStorming), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendServerFogDistanceToClient(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SendFogStateToClient(this.isStorming), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

