/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.carvers;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;

public class ModConfiguredCarver {
    public static final ResourceKey<ConfiguredWorldCarver<?>> ABYSS_CAVE = ModConfiguredCarver.createKey("abyss_cave");

    private static ResourceKey<ConfiguredWorldCarver<?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_CARVER, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredWorldCarver<?>> ctx) {
        ctx.register(ABYSS_CAVE, (Object)WorldCarver.CAVE.configured((CarverConfiguration)ModConfiguredCarver.getCaveCarver(ctx)));
    }

    public static CaveCarverConfiguration getCaveCarver(BootstrapContext<ConfiguredWorldCarver<?>> ctx) {
        HolderGetter holdergetter = ctx.lookup(Registries.BLOCK);
        return new CaveCarverConfiguration(0.2f, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)8), (VerticalAnchor)VerticalAnchor.absolute((int)30)), (FloatProvider)UniformFloat.of((float)1.0f, (float)5.0f), VerticalAnchor.aboveBottom((int)0), CarverDebugSettings.of((boolean)false, (BlockState)Blocks.CRIMSON_BUTTON.defaultBlockState()), (HolderSet)holdergetter.getOrThrow(BlockTags.OVERWORLD_CARVER_REPLACEABLES), (FloatProvider)UniformFloat.of((float)2.0f, (float)3.5f), (FloatProvider)UniformFloat.of((float)5.0f, (float)7.0f), (FloatProvider)UniformFloat.of((float)-1.0f, (float)-0.5f));
    }
}

