/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import wardentools.block.BlockRegistry;
import wardentools.worldgen.features.ModFeatures;
import wardentools.worldgen.features.custom.DepthVineConfiguration;
import wardentools.worldgen.features.custom.cristals.CristalFormationConfiguration;
import wardentools.worldgen.features.custom.cristals.CristalVeinConfiguration;
import wardentools.worldgen.features.custom.sculk.AbyssSculkPatchConfiguration;
import wardentools.worldgen.features.custom.sculk.LivingSproutEmergenceConfiguration;
import wardentools.worldgen.features.custom.sculk.SculkTendrilsEmergenceConfiguration;
import wardentools.worldgen.tree.custom.DarktreeFoliagePlacer;
import wardentools.worldgen.tree.custom.DarktreeTrunkPlacer;
import wardentools.worldgen.tree.custom.WhitetreeFoliagePlacer;
import wardentools.worldgen.tree.custom.WhitetreeTrunkPlacer;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARKTREE_KEY = ModConfiguredFeatures.registerKey("darktree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITETREE_KEY = ModConfiguredFeatures.registerKey("whitetree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_GRASS = ModConfiguredFeatures.registerKey("white_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_WHITE_GRASS = ModConfiguredFeatures.registerKey("tall_white_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_TORCHFLOWER = ModConfiguredFeatures.registerKey("white_torchflower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEEPFLOWER = ModConfiguredFeatures.registerKey("deepflower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_BUSH = ModConfiguredFeatures.registerKey("blue_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_DARK_GRASS = ModConfiguredFeatures.registerKey("tall_dark_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_GRASS = ModConfiguredFeatures.registerKey("dark_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COAL_ORE = ModConfiguredFeatures.registerKey("coal_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LAPIS_ORE = ModConfiguredFeatures.registerKey("lapis_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DIAMOND_ORE = ModConfiguredFeatures.registerKey("diamond_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEEP_ORE = ModConfiguredFeatures.registerKey("deep_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> REDSTONE_ORE = ModConfiguredFeatures.registerKey("redstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIQUID_CORRUPTION_FLOOR = ModConfiguredFeatures.registerKey("liquid_corruption_floor");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHARP_ROCK = ModConfiguredFeatures.registerKey("sharp_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MALACHITE_CRISTAL = ModConfiguredFeatures.registerKey("malachite_cristal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RUBY_CRISTAL = ModConfiguredFeatures.registerKey("ruby_cristal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CITRINE_CRISTAL = ModConfiguredFeatures.registerKey("citrine_cristal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ECHO_CRISTAL = ModConfiguredFeatures.registerKey("echo_cristal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALE_CRISTAL = ModConfiguredFeatures.registerKey("pale_cristal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMETHYST_CRISTAL = ModConfiguredFeatures.registerKey("amethyst_cristal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MALACHITE_VEIN = ModConfiguredFeatures.registerKey("malachite_vein");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RUBY_VEIN = ModConfiguredFeatures.registerKey("ruby_vein");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CITRINE_VEIN = ModConfiguredFeatures.registerKey("citrine_vein");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ECHO_VEIN = ModConfiguredFeatures.registerKey("echo_vein");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALE_CRISTAL_VEIN = ModConfiguredFeatures.registerKey("pale_cristal_vein");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMETHYST_VEIN = ModConfiguredFeatures.registerKey("amethyst_vein");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SCULK_TENDRIL_EMERGENCE = ModConfiguredFeatures.registerKey("sculk_tendril_emergence");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SCULK_TENDRIL_EMERGENCE_DOWN = ModConfiguredFeatures.registerKey("sculk_tendril_emergence_down");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ABYSS_SCULK_PATCH = ModConfiguredFeatures.registerKey("abyss_sculk_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_DEPTH_VINE = ModConfiguredFeatures.registerKey("tall_depth_vine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIVING_SPROUT_EMERGENCE = ModConfiguredFeatures.registerKey("living_sprout_emergence");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.register(context, DARKTREE_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.DARKTREE_LOG.get())), (TrunkPlacer)new DarktreeTrunkPlacer(6, 4, 3), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.DARKTREE_LEAVES.get())), (FoliagePlacer)new DarktreeFoliagePlacer((IntProvider)ConstantInt.of((int)5), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
        ModConfiguredFeatures.register(context, WHITETREE_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.WHITETREE_LOG.get())), (TrunkPlacer)new WhitetreeTrunkPlacer(6, 4, 4), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.WHITETREE_LEAVES.get())), (FoliagePlacer)new WhitetreeFoliagePlacer((IntProvider)ConstantInt.of((int)5), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build());
        ModConfiguredFeatures.register(context, WHITE_GRASS, Feature.RANDOM_PATCH, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.WHITE_GRASS.get())), 40));
        ModConfiguredFeatures.register(context, TALL_WHITE_GRASS, Feature.RANDOM_PATCH, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.TALL_WHITE_GRASS.get())), 20));
        ModConfiguredFeatures.register(context, WHITE_TORCHFLOWER, Feature.RANDOM_PATCH, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.WHITE_TORCHFLOWER.get())), 2));
        ModConfiguredFeatures.register(context, DEEPFLOWER, Feature.RANDOM_PATCH, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.DEEPFLOWER.get())), 1));
        ModConfiguredFeatures.register(context, BLUE_BUSH, Feature.RANDOM_PATCH, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.BLUE_BUSH.get())), 10));
        ModConfiguredFeatures.register(context, TALL_DARK_GRASS, Feature.RANDOM_PATCH, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.TALL_DARK_GRASS.get())), 5));
        ModConfiguredFeatures.register(context, DARK_GRASS, Feature.RANDOM_PATCH, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistry.DARK_GRASS.get())), 15));
        ModConfiguredFeatures.register(context, COAL_ORE, Feature.ORE, ModConfiguredFeatures.oreGeneration(17, 0.0f, (Block)BlockRegistry.ABYSSALITE_COAL_ORE.get(), Blocks.DEEPSLATE_COAL_ORE));
        ModConfiguredFeatures.register(context, LAPIS_ORE, Feature.ORE, ModConfiguredFeatures.oreGeneration(8, 0.0f, (Block)BlockRegistry.ABYSSALITE_LAPIS_ORE.get(), Blocks.DEEPSLATE_LAPIS_ORE));
        ModConfiguredFeatures.register(context, DIAMOND_ORE, Feature.ORE, ModConfiguredFeatures.oreGeneration(8, 0.7f, (Block)BlockRegistry.ABYSSALITE_DIAMOND_ORE.get(), Blocks.DEEPSLATE_DIAMOND_ORE));
        ModConfiguredFeatures.register(context, DEEP_ORE, Feature.ORE, ModConfiguredFeatures.oreGeneration(5, 0.0f, (Block)BlockRegistry.ABYSSALITE_DEEP_ORE.get()));
        ModConfiguredFeatures.register(context, REDSTONE_ORE, Feature.ORE, ModConfiguredFeatures.oreGeneration(7, 0.7f, (Block)BlockRegistry.ABYSSALITE_REDSTONE_ORE.get(), Blocks.DEEPSLATE_REDSTONE_ORE));
        ModConfiguredFeatures.register(context, LIQUID_CORRUPTION_FLOOR, ModFeatures.REPLACE_AIR_BELOW_Y.get(), new NoneFeatureConfiguration());
        ModConfiguredFeatures.register(context, SHARP_ROCK, ModFeatures.SHARP_ROCK.get(), new NoneFeatureConfiguration());
        ModConfiguredFeatures.register(context, MALACHITE_CRISTAL, ModFeatures.CRISTAL_FORMATION.get(), new CristalFormationConfiguration(12, 3.0f, 5, ((Block)BlockRegistry.MALACHITE_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.MALACHITE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, RUBY_CRISTAL, ModFeatures.CRISTAL_FORMATION.get(), new CristalFormationConfiguration(9, 4.0f, 7, ((Block)BlockRegistry.RUBY_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.RUBY.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, CITRINE_CRISTAL, ModFeatures.CRISTAL_FORMATION.get(), new CristalFormationConfiguration(15, 5.0f, 4, ((Block)BlockRegistry.CITRINE_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.CITRINE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, ECHO_CRISTAL, ModFeatures.CRISTAL_FORMATION.get(), new CristalFormationConfiguration(12, 6.0f, 4, ((Block)BlockRegistry.ECHO_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.ECHO_CRISTAL.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, PALE_CRISTAL, ModFeatures.CRISTAL_FORMATION.get(), new CristalFormationConfiguration(13, 5.0f, 10, ((Block)BlockRegistry.PALE_CRISTAL_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.PALE_CRISTAL.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, AMETHYST_CRISTAL, ModFeatures.CRISTAL_FORMATION.get(), new CristalFormationConfiguration(13, 5.0f, 10, Blocks.AMETHYST_BLOCK.defaultBlockState(), Blocks.AMETHYST_CLUSTER.defaultBlockState()));
        ModConfiguredFeatures.register(context, MALACHITE_VEIN, ModFeatures.CRISTAL_VEIN.get(), new CristalVeinConfiguration(5, 2, 4, ((Block)BlockRegistry.MALACHITE_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.MALACHITE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, RUBY_VEIN, ModFeatures.CRISTAL_VEIN.get(), new CristalVeinConfiguration(5, 2, 4, ((Block)BlockRegistry.RUBY_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.RUBY.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, CITRINE_VEIN, ModFeatures.CRISTAL_VEIN.get(), new CristalVeinConfiguration(5, 2, 4, ((Block)BlockRegistry.CITRINE_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.CITRINE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, ECHO_VEIN, ModFeatures.CRISTAL_VEIN.get(), new CristalVeinConfiguration(5, 2, 4, ((Block)BlockRegistry.ECHO_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.ECHO_CRISTAL.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, PALE_CRISTAL_VEIN, ModFeatures.CRISTAL_VEIN.get(), new CristalVeinConfiguration(5, 2, 4, ((Block)BlockRegistry.PALE_CRISTAL_BLOCK.get()).defaultBlockState(), ((Block)BlockRegistry.PALE_CRISTAL.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, AMETHYST_VEIN, ModFeatures.CRISTAL_VEIN.get(), new CristalVeinConfiguration(5, 2, 4, Blocks.AMETHYST_BLOCK.defaultBlockState(), Blocks.AMETHYST_CLUSTER.defaultBlockState()));
        ModConfiguredFeatures.register(context, SCULK_TENDRIL_EMERGENCE, ModFeatures.SCULK_TENDRILS_EMERGENCE.get(), new SculkTendrilsEmergenceConfiguration(15, 0.5f, 5, 0.95f, 0.4f, true));
        ModConfiguredFeatures.register(context, SCULK_TENDRIL_EMERGENCE_DOWN, ModFeatures.SCULK_TENDRILS_EMERGENCE.get(), new SculkTendrilsEmergenceConfiguration(15, 0.5f, 5, 0.95f, 0.4f, false));
        ModConfiguredFeatures.register(context, ABYSS_SCULK_PATCH, ModFeatures.ABYSS_SCULK_PATCH.get(), new AbyssSculkPatchConfiguration(10, 32, 64, 0, 1, (IntProvider)ConstantInt.of((int)0), 0.5f, true));
        ModConfiguredFeatures.register(context, TALL_DEPTH_VINE, ModFeatures.DEPTH_VINE.get(), new DepthVineConfiguration(true, 10, 1, 100));
        ModConfiguredFeatures.register(context, LIVING_SPROUT_EMERGENCE, ModFeatures.LIVING_SPROUT_EMERGENCE.get(), new LivingSproutEmergenceConfiguration(1, 7, 0.2f, true));
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider stateProvider, int tries) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)tries, (Holder)PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(stateProvider), (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.AIR, Blocks.SCULK_VEIN})));
    }

    public static OreConfiguration oreGeneration(int size, float discardChanceOnAirExposure, Block abyssaliteReplaceable, Block deepslateReplaceable) {
        OreConfiguration.TargetBlockState abyssaliteTarget = OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlockRegistry.ABYSSALITE.get()), (BlockState)abyssaliteReplaceable.defaultBlockState());
        OreConfiguration.TargetBlockState deepslateTarget = OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)deepslateReplaceable.defaultBlockState());
        return new OreConfiguration(List.of(abyssaliteTarget, deepslateTarget), size, discardChanceOnAirExposure);
    }

    public static OreConfiguration oreGeneration(int size, float discardChanceOnAirExposure, Block abyssaliteReplaceable) {
        OreConfiguration.TargetBlockState abyssaliteTarget = OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlockRegistry.ABYSSALITE.get()), (BlockState)abyssaliteReplaceable.defaultBlockState());
        return new OreConfiguration(List.of(abyssaliteTarget), size, discardChanceOnAirExposure);
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

