/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import org.jetbrains.annotations.NotNull;
import wardentools.worldgen.structure.ModStructureTypes;

public class CrystalTemple
extends Structure {
    public static final MapCodec<CrystalTemple> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)ResourceKey.codec((ResourceKey)Registries.TEMPLATE_POOL).fieldOf("start_pool").forGetter(s -> s.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(s -> s.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(s -> s.maxDepth), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(s -> s.maxDistanceFromCenter), (App)TagKey.hashedCodec((ResourceKey)Registries.BIOME).optionalFieldOf("cave_biome_underneath").forGetter(s -> s.caveBiomeUnderneath)).apply((Applicative)instance, CrystalTemple::new));
    public static final Codec<CrystalTemple> CODEC = MAP_CODEC.codec();
    private static final TagKey<Biome> DEFAULT_CAVE_BIOME = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"amethyst_cave"));
    private final ResourceKey<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final int maxDistanceFromCenter;
    private final Optional<TagKey<Biome>> caveBiomeUnderneath;

    public CrystalTemple(Structure.StructureSettings settings, ResourceKey<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, int maxDistanceFromCenter, Optional<TagKey<Biome>> caveBiomeUnderneath) {
        super(settings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.caveBiomeUnderneath = caveBiomeUnderneath;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(@NotNull Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int x = chunkPos.getMiddleBlockX();
        int z = chunkPos.getMiddleBlockZ();
        if (!CrystalTemple.biomeColumnCheck(context, this.caveBiomeUnderneath.orElse(DEFAULT_CAVE_BIOME))) {
            return Optional.empty();
        }
        int y = context.chunkGenerator().getFirstFreeHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        BlockPos pos = new BlockPos(x, y += 2, z);
        Registry poolRegistry = context.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        Optional poolHolder = poolRegistry.getHolder(this.startPool);
        return poolHolder.flatMap(structureTemplatePoolReference -> JigsawPlacement.addPieces((Structure.GenerationContext)context, (Holder)structureTemplatePoolReference, this.startJigsawName, (int)this.maxDepth, (BlockPos)pos, (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)new DimensionPadding(1), (LiquidSettings)LiquidSettings.APPLY_WATERLOGGING));
    }

    private static boolean biomeColumnCheck(Structure.GenerationContext context, TagKey<Biome> tag) {
        ChunkPos chunkPos = context.chunkPos();
        int x = chunkPos.getMiddleBlockX();
        int z = chunkPos.getMiddleBlockZ();
        boolean hasBiomeInColumn = false;
        for (int checkY = context.heightAccessor().getMinBuildHeight(); checkY < context.heightAccessor().getMaxBuildHeight(); checkY += 32) {
            Holder biome = context.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)x), QuartPos.fromBlock((int)checkY), QuartPos.fromBlock((int)z), context.randomState().sampler());
            if (!biome.is(tag)) continue;
            hasBiomeInColumn = true;
            break;
        }
        return hasBiomeInColumn;
    }

    @NotNull
    public StructureType<CrystalTemple> type() {
        return ModStructureTypes.CRYSTAL_TEMPLE.get();
    }
}

